package com.reyun.controller.manage;

import com.reyun.dic.VirtualEventType;
import com.reyun.model.Account;
import com.reyun.model.Event4Web;
import com.reyun.model.VirtualEvent;
import com.reyun.repository.VirtualEventRepository;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.VirtualEventService;
import com.reyun.util.PinYinUtil;
import com.reyun.util.ResultModel;
import com.reyun.util.ResultStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * Created by song on 2017/9/4.
 */

@Controller
@RequestMapping("/mng/virtual")
public class MngActiveRetentionController {

    @Autowired
    private VirtualEventService virtualEventService;

    @Autowired
    private VirtualEventRepository virtualEventRepository;

    @RequestMapping(value = "find/{appId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel list(@PathVariable Long appId, @CurrentAccount Account loginAccount) {
        List<VirtualEvent> eventList = virtualEventService.findEventList(appId, loginAccount);
        return ResultModel.OK(eventList);
    }


    @RequestMapping(value = "finddetails/{appId}/{id}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel listDetails(@PathVariable Long appId, @CurrentAccount Account loginAccount, @PathVariable Long id) {
        List<Event4Web> activeEventList = virtualEventService.findActiveEventList(appId, id);
        return ResultModel.OK(activeEventList);
    }


    @RequestMapping(value = "update/{appId}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel update(@PathVariable Long appId, @RequestBody VirtualEvent virtualEvent, @CurrentAccount Account account) {
        if (virtualEvent.getType().equals("active")) {
            VirtualEvent virtualEvent1 = virtualEventService.updateEvent(appId, account, virtualEvent);
            return ResultModel.OK(virtualEvent1);
        } else {
            Long id = virtualEvent.getId();
            List<VirtualEvent> eventListByIdNot = virtualEventRepository.findEventListByIdNot(id);
            String pingYin_name = PinYinUtil.getPingYin("vir_" + virtualEvent.getCh_name().replace(" ", "") + "_" + appId);
            if (!CollectionUtils.isEmpty(eventListByIdNot)) {
                for (VirtualEvent virtualEvent1 : eventListByIdNot) {
                    if (virtualEvent1.getName().equals(pingYin_name)) {
                        return ResultModel.ERROR(ResultStatus.NAME_EXIST);
                    }
                }
            }
            if (virtualEvent.getCh_name().replace(" ", "").isEmpty()) {
                return ResultModel.ERROR(ResultStatus.NAME_NULL);
            } else {
                VirtualEvent virtualEvent1 = virtualEventService.updateEvent(appId, account, virtualEvent);
                return ResultModel.OK(virtualEvent1);
            }
        }
    }


    @RequestMapping(value = "unselect/{app}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel unselect(@CurrentAccount Account account, @PathVariable Long app) {
        List<Event4Web> event4Webs = virtualEventService.unselectedEvent(app);
        return ResultModel.OK(event4Webs);
    }


    @RequestMapping(value = "userdefined/{appId}", method = RequestMethod.POST)
    @ResponseBody
    public ResultModel userdefined(@PathVariable Long appId, @RequestBody VirtualEvent virtualEvent, @CurrentAccount Account account) {
        List<VirtualEvent> eventListUserDefine = virtualEventRepository.findEventListByAppIdAndType(appId, VirtualEventType.USERDEFINEDEVENT.getCode());
        String pingYin_name = PinYinUtil.getPingYin("vir_" + virtualEvent.getCh_name().replace(" ", "") + "_" + appId);
        if (!CollectionUtils.isEmpty(eventListUserDefine)) {
            for (VirtualEvent virtualEvent1 : eventListUserDefine) {
                if (virtualEvent1.getName().equals(pingYin_name)) {
                    return ResultModel.ERROR(ResultStatus.NAME_EXIST);
                }
            }
        }
        if (virtualEvent.getCh_name().replace(" ", "").isEmpty()) {
            return ResultModel.ERROR(ResultStatus.NAME_NULL);
        } else {
            VirtualEvent userDefineEvent = virtualEventService.userDefineVirtual(appId, virtualEvent, account);
            return ResultModel.OK(userDefineEvent);
        }
    }


    @RequestMapping(value = "findcustom/{appId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findcustom(@PathVariable Long appId, @CurrentAccount Account loginAccount) {
        List<VirtualEvent> eventList = virtualEventService.findCustomEventList(appId, loginAccount);
        return ResultModel.OK(eventList);
    }


    @RequestMapping(value = "find/{id}/enable", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel enable(@PathVariable Long id, @CurrentAccount Account loginAccount) {
        List<VirtualEvent> eventList = virtualEventService.enableEvent(id);
        return ResultModel.OK(eventList);
    }


    @RequestMapping(value = "find/{id}/disable", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel disable(@PathVariable Long id, @CurrentAccount Account loginAccount) {
        List<VirtualEvent> eventList = virtualEventService.disableEvent(id);
        return ResultModel.OK(eventList);
    }
}
