package com.reyun.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.util.Date;

/**
 * Created by sunhao on 17/4/20.
 * desc:我的看单模板
 */
@Entity
public class CustomMenuTemplate {

    private Long id;

    private Long accountId;

    private Long customMenuId;
    //模板名称
    private String name;
    //报表类型,事件分析,漏斗,留存
    private  String menuType;
    //漏斗,留存,事件分析的ID
    private Long originalReportId;

    private Date createDate;

    private Long modifyAccount;

    private Date modifyDate;

    private Boolean delFlag;
    //模板显示顺序
    private Integer orderindex;
    //模板显示形式，折线、表格......
    private String type;

    public CustomMenuTemplate(){}

    public CustomMenuTemplate(CustomMenuTemplate customMenuTemplate){
        this.accountId = customMenuTemplate.getAccountId();
        this.name = customMenuTemplate.getName();
        this.menuType = customMenuTemplate.getMenuType();
        this.modifyAccount = customMenuTemplate.getModifyAccount();
        this.originalReportId = customMenuTemplate.getOriginalReportId();
        this.createDate = new Date();
        this.modifyDate = new Date();
        this.delFlag = false;
    }

    public CustomMenuTemplate(CustomMenuShareTemplate customMenuShareTemplate){

        this.accountId = customMenuShareTemplate.getAccountId();
        this.name = customMenuShareTemplate.getName();
        this.menuType = customMenuShareTemplate.getMenuType();
        this.modifyAccount = customMenuShareTemplate.getModifyAccount();
        this.createDate = new Date();
        this.modifyDate = new Date();
        this.delFlag = false;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getCustomMenuId() {
        return customMenuId;
    }

    public void setCustomMenuId(Long customMenuId) {
        this.customMenuId = customMenuId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMenuType() {
        return menuType;
    }

    public void setMenuType(String menuType) {
        this.menuType = menuType;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getModifyAccount() {
        return modifyAccount;
    }

    public void setModifyAccount(Long modifyAccount) {
        this.modifyAccount = modifyAccount;
    }

    public Date getModifyDate() {
        return modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public Boolean getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Boolean delFlag) {
        this.delFlag = delFlag;
    }

    public Long getOriginalReportId() {
        return originalReportId;
    }

    public void setOriginalReportId(Long originalReportId) {
        this.originalReportId = originalReportId;
    }

    public Integer getOrderindex() {
        return orderindex;
    }

    public void setOrderindex(Integer orderindex) {
        this.orderindex = orderindex;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
