package com.reyun.repository;

import java.util.List;
import java.util.Map;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import com.reyun.model.Auth;
@Transactional
public interface AuthRepository extends JpaRepository<Auth, Long> {

    @Query(value = "select * from auth where account  = ?1 and status is true ", nativeQuery = true)
    List<Auth> findAuthByAccountId(Long accountId);

    @Query(value = "select * from auth where account  = ?1 and create_account in ?2 and status is true ", nativeQuery = true)
    List<Auth> findAuthByCreateIds(Long subAccountId, List<Long> createAccount);

    @Query(value = "select * from auth where account = ?1 and app = ?2 limit 1", nativeQuery = true)
    Auth findAuthByAccountAndApp(Long account, Long app);

    @Query(value = "select distinct account from auth where create_account in ?1 and status is true ", nativeQuery = true)
    List<Long> findActiveChannelAuth(List<Long> createAccountList);

    @Query(value = "select distinct account from auth where create_account in ?1 and status is not true ", nativeQuery = true)
    List<Long> findDisableChannelAuth(List<Long> createAccountList);

    @Query(value = "select * from auth where create_account in ?1  and account = ?2 ", nativeQuery = true)
    List<Auth> findAuthByCreateAccount(List<Long> createAccountList, Long channelAccount);

    @Query(value = "select * from auth where create_account in ?1 and account = ?2", nativeQuery = true)
    List<Auth> findAuthByCreateAndAuth(List<Long> createAccountList, Long authAccount);

    @Query(value = "select * from auth where role_category = ?1 ", nativeQuery = true)
    List<Auth> findAuthByRoleCategory(Long roleCategory);

    @Query(value = "select app from auth where account = ?1 and status is true ", nativeQuery = true)
    List<Long> findAppListByAccount(Long accountId);

    @Transactional
    @Modifying
    @Query(value = "update auth set status = ?3 where account = ?1 and create_account in ?2 ", nativeQuery = true)
    int updateStatusByCreateAccount(Long channelAccount, List<Long> createAccountList, Boolean status);

    @Transactional
    @Modifying
    @Query(value = "delete from auth where account = ?1", nativeQuery = true)
    void deleteAuthByAccount(Long account);

	Iterable<Auth> findByApp(Long id);

    @Query(value="select account.email from data_auth,account where account.id=data_auth.account and app=?1 and all_campaign is true and channel=?2", nativeQuery = true)
    List<String> findAllcampaignAccountByChanelApp(Long app, Long channel);
}
