package com.reyun.repository;

import com.reyun.model.CustomMenuShareTemplate;
import com.reyun.model.CustomMenuTemplate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by sunhao on 17/4/27.
 * desc:分析看单模板DAO
 */
public interface CustomMenuShareTempRepository extends JpaRepository<CustomMenuShareTemplate,Long>{

    @Query(value = "select * from custom_menu_share_template where custom_menu_id = ?1 and del_flag is false ", nativeQuery = true)
    List<CustomMenuShareTemplate> findShareTemplateById(Long customMenuId);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu_share_template set query_data = ?2 where id = ?1 ", nativeQuery = true)
    int updateQueryDataById(Long templateId, String queryData);
}
