package com.reyun.repository;

import com.reyun.model.Event;
import com.reyun.model.EventMeta;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface EventMetaRepository extends JpaRepository<EventMeta, Long> {

    List<EventMeta> findByAppkey(String appkey);

    @Query(value = "select * from event_meta where appkey = ?1 and event_id = ?2", nativeQuery = true)
    EventMeta findByEventId(String appkey, String name);

    @Query(value = "select * from event_meta where `appkey`=?1 and (`alias`=?2 OR `event_id`=?2)", nativeQuery = true)
    EventMeta findByAliasOrName(String appkey, String alias);

    @Query(value = "select * from event_meta where appkey = ?1 and event_id in (?2) ", nativeQuery = true)
    List<EventMeta> findByEventIds(String appKey, List<String> eventList);

    @Query(value = "select * from event_meta where appkey = ?1 and status is false", nativeQuery = true)
    List<EventMeta> findByAppkeyAndStatusIsFalse(String appkey);

    @Query(value = "select * from event_meta where appkey = ?1 and status is true", nativeQuery = true)
    List<EventMeta> findByAppkeyAndStatusIsTrue(String appkey);
}
