package com.reyun.service;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.reyun.model.Account;
import com.reyun.model.UserLog;
import com.reyun.util.DateUtil;
import com.reyun.util.StringUtil;

public interface UserLogService {

	
	/**
	 * 插入审计日志
	 * @param account
	 * @param type
	 * @param content
	 * @return
	 */
	public boolean insertLog(Account account, String type, String typeName, Object object);

	public boolean insertLog(Account account, String type, String typeName, Object object, HttpServletRequest request);
	
	public boolean insertLog(Account account, String type, String typeName, Object object, Long app, String ObjectType);

	public boolean insertLog(HttpServletRequest request, String type, String typeName, Long app, String ObjectType);

	public boolean insertLog(Account account, String type, String typeName, Object object, Long app, String ObjectType,HttpServletRequest request);

	public boolean insertLog(Account account, String type, String typeName, List object, Long app, String ObjectType,HttpServletRequest request);

	public boolean insertLog(Account account, String type, String typeName, String content, Long app, String ObjectType,HttpServletRequest request);

	/**
	 * 查询审计日志列表
	 * @param email
	 * @param type
	 * @param startDate
	 * @param endDate
	 * @param pageIndex
	 * @param pageSize
	 * @return
	 */
	public List<UserLog> findUserLogList(String email, String type, String startDate, String endDate, int pageIndex, int pageSize);
	
	/**
	 * 查询满足条件的日志数量
	 * @param email
	 * @param type
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	public BigInteger findUserLogCount(String email, String type, String startDate, String endDate);
	

}
