package com.reyun.taskexecute;

import com.reyun.context.AppUtils;
import com.reyun.model.App;
import com.reyun.model.UserLog;
import com.reyun.repository.AppRepository;
import com.reyun.repository.UserLogRepository;
import com.reyun.service.impl.UserLogServiceImpl;
import com.reyun.util.DateUtil;
import com.reyun.util.IPAddrUtil;
import com.reyun.util.ValidateUtil;
import net.sf.json.JSONObject;
import net.sf.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;

import java.util.Date;
import java.util.List;

/**
 * Created by zxy on 2017/12/15.
 */
public class UserLogThread extends Thread
{
    protected Logger logger = LoggerFactory.getLogger(UserLogThread.class);

    private AppRepository appRepository = AppUtils.getApplicationContext().getBean(AppRepository.class);
    private UserLogRepository userLogRepository = AppUtils.getApplicationContext().getBean(UserLogRepository.class);
    private String type;
    private String email;
    private boolean isMasterLogin;
    private String operaType;
    private String operaContent;
    private Object content;
    private List contentList;
    private String contentStr;
    private Long app;
    private String appName;
    private String objectType;
    private HttpServletRequest request;

    /**
     * 传入内容为对象
     * @param email
     * @param isMasterLogin
     * @param type
     * @param operaType
     * @param content
     * @param request
     * @param app
     * @param objectType
     */
    public UserLogThread(String email, boolean isMasterLogin, String type, String operaType, Object content, HttpServletRequest request, Long app, String objectType)
    {
        this.type = type;
        this.email = email;
        this.isMasterLogin = isMasterLogin;
        this.operaType = operaType;
        this.content = content;
        this.app = app;
        this.objectType = objectType;
        this.request = request;
    }

    /**
     * 传入内容为列表
     * @param email
     * @param isMasterLogin
     * @param type
     * @param operaType
     * @param content
     * @param request
     * @param app
     * @param objectType
     */
    public UserLogThread(String email, boolean isMasterLogin, String type, String operaType, List content, HttpServletRequest request, Long app, String objectType)
    {
        this.type = type;
        this.email = email;
        this.isMasterLogin = isMasterLogin;
        this.operaType = operaType;
        this.contentList = content;
        this.app = app;
        this.objectType = objectType;
        this.request = request;
    }

    /**
     * 传入内容为字符串
     * @param email
     * @param isMasterLogin
     * @param type
     * @param operaType
     * @param content
     * @param request
     * @param app
     * @param objectType
     */
    public UserLogThread(String email, boolean isMasterLogin, String type, String operaType, String content, HttpServletRequest request, Long app, String objectType)
    {
        this.type = type;
        this.email = email;
        this.isMasterLogin = isMasterLogin;
        this.operaType = operaType;
        this.contentStr = content;
        this.app = app;
        this.objectType = objectType;
        this.request = request;
    }

    @Override
    public void run()
    {
        try
        {
            if (this.content != null) {
                System.out.println(this.content);
                this.operaContent = JSONObject.fromObject(this.content).toString();
            } else if (this.contentList != null) {
                System.out.println(this.contentList);
                this.operaContent = JSONArray.fromObject(this.contentList).toString();
            } else if (this.contentStr != null) {
                System.out.println(this.contentStr);
                this.operaContent = this.contentStr;
            }
            UserLog audit = new UserLog();
            audit.setEmail(this.email);
            audit.setMasterLogin(this.isMasterLogin);
            if (this.app != null) {
                App appObject = appRepository.findOne(this.app);
                audit.setApp(this.app);
                audit.setAppName(appObject.getName());
            }

            audit.setObjectType(this.objectType);

            audit.setPubDate(new Date());
            audit.setDs(DateUtil.format(new Date()));
            audit.setOperaContent(this.operaContent);

            if (this.request != null) {
                String ipAddr = IPAddrUtil.getIpAddrNew(request);
                audit.setIp(ipAddr);
                if(ValidateUtil.isValid(ipAddr)){
                    String locationFromIpAddr = IPAddrUtil.getLocationFromIpAddr(ipAddr);
                    audit.setLocation(locationFromIpAddr);
                }
            }

            audit.setOperaType(this.operaType);
            audit.setType(type);

            userLogRepository.save(audit);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
