(function(){
     angular.module("app.login")
        .controller("loginCtrl",["$scope","OptionService","DateService","$filter","UtilService","HttpService",loginCtrl]);

    function loginCtrl($scope,OptionService,DateService,$filter,UtilService,HttpService){
        TrackingIO.init(UtilService.getTKAppkey());

        $scope.now = DateService.getYesDay().startDate;
        $scope.reportDate =  DateService.getYesDay().startDate;
        $scope.isrember = false;
        $scope.isonline = true;

        var uname = UtilService.getCookie("ryioUname");
        if(!UtilService.isNullStr(uname)){
            $scope.name = uname;
        }

        var code = "";
        $scope.getImgInfo = function(){
            var selectChar = new Array(1,2,3,4,5,6,7,8,9,'a','b','c','d','e','f','g','h','j','k','l','m','n','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','J','K','L','M','N','P','Q','R','S','T','U','V','W','X','Y','Z');
            code = "";
            var len = selectChar.length;
            for(var i=0;i<4;i++) {
               var charIndex = Math.floor(Math.random()*len);
               code +=selectChar[charIndex];
            }
            document.getElementById("imgMa").src = "api/login/getvalidcode?code="+code;
        }
        $scope.getImgInfo();

        $scope.doLogin = function(){
            var par = {
                email: $scope.name,
                password: $scope.password,
                autologin: $scope.isonline,
                isrember:$scope.isrember
            };
            var verPar = {
                name: {
                    key: 'isNull',
                    val: par.email
                },
                password: {
                    key: 'isNull',
                    val: par.password
                },
                yema: {
                    key: 'isNull',
                    val: $scope.yema
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                return false;
            }
            if(angular.uppercase($scope.yema)!=angular.uppercase(code)){
                $scope.tip = {
                    yema:{
                        status:true,
                        txt:"验证码错误"
                    }
                };
                $scope.getImgInfo();
                return false;
            }
            else{
            	var loginPM = HttpService.getInfo("login/loginweb",par);
                loginPM.then(function(data){
                    if(data.code == 200){
                        var account = data.account,token = data.token;

                        if(account.status == -3){
                            $scope.noActive = 1;
                            $scope.registerId = account.id;
                            UtilService.setCookie("regId",account.id,7);
                            UtilService.setCookie("regEmail",$scope.name,7);
                            UtilService.setCookie("regFlag",0,7);
                        }
                        else{
                          TrackingIO.loggedin(account.email);

                          window.localStorage.setItem("io_ry_user",JSON.stringify(account));
                          UtilService.setCookie("ryioUname",account.email);
                          UtilService.setCookie("ryioToken",token,7);////

                          var isSuper = account.isSuperUser == true && account.isChannelPerson!=true;
                          UtilService.setCookie("ryioIsSuper",isSuper,7);///////

                          if( data.account.activeStatus != true && data.account.status == 1 && isSuper==true){
                              UtilService.setCookie("regId",account.id,7);
                              UtilService.setCookie("regEmail",$scope.name,7);
                              UtilService.setCookie("regFlag",1,7);
                              window.location.href = "olduser.html";
                          }else{
                              if(data.account.status == 1){
                                  window.location.href = "index.html#/manage/app";
                              }
                              else{
                                  window.location.href = "index.html#/active/product";
                              }
                          }
                        }
                    }else{
                        $scope.tip = {
                            password:{
                                status:true,
                                txt:data.msg
                            }
                        };
                    }
                });
            }
        }

        $scope.noActive = 0;
        $scope.closeWin = function(){
            $scope.noActive = 0;
            $scope.loginSend = 'yes';
        }
        $scope.loginSend = 'yes';
        $scope.sendAgain = function(){
            $scope.loginSend = 'no';
            var sendPM = HttpService.getInfo("reged/sendeactivemail/"+$scope.registerId+"/"+0);
            sendPM.then(function(data){
                window.location.href = "activation.html";
            });
        }

        $scope.keyEvt= function(e){
            if(e.keyCode == 13){
                $scope.doLogin();
            }
        }
    }
})();
