/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.entity;

import com.dianping.cat.status.model.BaseEntity;
import com.dianping.cat.status.model.IVisitor;
import com.dianping.cat.status.model.entity.GcInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryInfo
extends BaseEntity<MemoryInfo> {
    private long m_max;
    private long m_total;
    private long m_free;
    private long m_heapUsage;
    private long m_nonHeapUsage;
    private List<GcInfo> m_gcs = new ArrayList<GcInfo>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitMemory(this);
    }

    public MemoryInfo addGc(GcInfo gc) {
        this.m_gcs.add(gc);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MemoryInfo) {
            MemoryInfo _o = (MemoryInfo)obj;
            if (this.getMax() != _o.getMax()) {
                return false;
            }
            if (this.getTotal() != _o.getTotal()) {
                return false;
            }
            if (this.getFree() != _o.getFree()) {
                return false;
            }
            if (this.getHeapUsage() != _o.getHeapUsage()) {
                return false;
            }
            if (this.getNonHeapUsage() != _o.getNonHeapUsage()) {
                return false;
            }
            return this.equals(this.getGcs(), _o.getGcs());
        }
        return false;
    }

    public long getFree() {
        return this.m_free;
    }

    public List<GcInfo> getGcs() {
        return this.m_gcs;
    }

    public long getHeapUsage() {
        return this.m_heapUsage;
    }

    public long getMax() {
        return this.m_max;
    }

    public long getNonHeapUsage() {
        return this.m_nonHeapUsage;
    }

    public long getTotal() {
        return this.m_total;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (int)(this.m_max ^ this.m_max >>> 32);
        hash = hash * 31 + (int)(this.m_total ^ this.m_total >>> 32);
        hash = hash * 31 + (int)(this.m_free ^ this.m_free >>> 32);
        hash = hash * 31 + (int)(this.m_heapUsage ^ this.m_heapUsage >>> 32);
        hash = hash * 31 + (int)(this.m_nonHeapUsage ^ this.m_nonHeapUsage >>> 32);
        for (GcInfo e : this.m_gcs) {
            hash = hash * 31 + (e == null ? 0 : e.hashCode());
        }
        return hash;
    }

    @Override
    public void mergeAttributes(MemoryInfo other) {
        this.m_max = other.getMax();
        this.m_total = other.getTotal();
        this.m_free = other.getFree();
        this.m_heapUsage = other.getHeapUsage();
        this.m_nonHeapUsage = other.getNonHeapUsage();
    }

    public MemoryInfo setFree(long free) {
        this.m_free = free;
        return this;
    }

    public MemoryInfo setHeapUsage(long heapUsage) {
        this.m_heapUsage = heapUsage;
        return this;
    }

    public MemoryInfo setMax(long max) {
        this.m_max = max;
        return this;
    }

    public MemoryInfo setNonHeapUsage(long nonHeapUsage) {
        this.m_nonHeapUsage = nonHeapUsage;
        return this;
    }

    public MemoryInfo setTotal(long total) {
        this.m_total = total;
        return this;
    }
}

