/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analysis;

import com.dianping.cat.Cat;
import com.dianping.cat.analysis.MessageAnalyzer;
import com.dianping.cat.analysis.MessageAnalyzerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageAnalyzerManager
extends ContainerHolder
implements MessageAnalyzerManager,
Initializable,
LogEnabled {
    private static final long MINUTE = 60000L;
    private long m_duration = 3600000L;
    private long m_extraTime = 180000L;
    private List<String> m_analyzerNames;
    private Map<Long, Map<String, List<MessageAnalyzer>>> m_analyzers = new HashMap<Long, Map<String, List<MessageAnalyzer>>>();
    protected Logger m_logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageAnalyzer> getAnalyzer(String name, long startTime) {
        List<MessageAnalyzer> analyzers;
        try {
            Map<String, List<MessageAnalyzer>> temp = this.m_analyzers.remove(startTime - this.m_duration * 2L);
            if (temp != null) {
                for (List map3 : temp.values()) {
                    for (MessageAnalyzer analyzer : map3) {
                        analyzer.destroy();
                    }
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        Map<String, List<MessageAnalyzer>> map = this.m_analyzers.get(startTime);
        if (map == null) {
            Map<Long, Map<String, List<MessageAnalyzer>>> map2 = this.m_analyzers;
            synchronized (map2) {
                map = this.m_analyzers.get(startTime);
                if (map == null) {
                    map = new HashMap<String, List<MessageAnalyzer>>();
                    this.m_analyzers.put(startTime, map);
                }
            }
        }
        if ((analyzers = map.get(name)) == null) {
            Map<String, List<MessageAnalyzer>> map2 = map;
            synchronized (map2) {
                analyzers = map.get(name);
                if (analyzers == null) {
                    analyzers = new ArrayList<MessageAnalyzer>();
                    MessageAnalyzer analyzer = (MessageAnalyzer)this.lookup(MessageAnalyzer.class, name);
                    analyzer.setIndex(0);
                    analyzer.initialize(startTime, this.m_duration, this.m_extraTime);
                    analyzers.add(analyzer);
                    int count = analyzer.getAnanlyzerCount();
                    for (int i = 1; i < count; ++i) {
                        MessageAnalyzer tempAnalyzer = (MessageAnalyzer)this.lookup(MessageAnalyzer.class, name);
                        tempAnalyzer.setIndex(i);
                        tempAnalyzer.initialize(startTime, this.m_duration, this.m_extraTime);
                        analyzers.add(tempAnalyzer);
                    }
                    map.put(name, analyzers);
                }
            }
        }
        return analyzers;
    }

    @Override
    public List<String> getAnalyzerNames() {
        return this.m_analyzerNames;
    }

    public void initialize() throws InitializationException {
        Map map = this.lookupMap(MessageAnalyzer.class);
        for (MessageAnalyzer analyzer : map.values()) {
            analyzer.destroy();
        }
        this.m_analyzerNames = new ArrayList(map.keySet());
        Collections.sort(this.m_analyzerNames, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                String state = "state";
                String top = "top";
                if (state.equals(str1)) {
                    return 1;
                }
                if (state.equals(str2)) {
                    return -1;
                }
                if (top.equals(str1)) {
                    return -1;
                }
                if (top.equals(str2)) {
                    return 1;
                }
                return str1.compareTo(str2);
            }
        });
        this.m_analyzerNames.remove("matrix");
        this.m_analyzerNames.remove("dependency");
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }
}

