/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analysis;

import com.dianping.cat.Cat;
import com.dianping.cat.analysis.AbstractMessageAnalyzer;
import com.dianping.cat.analysis.MessageAnalyzer;
import com.dianping.cat.message.spi.MessageQueue;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import java.util.Calendar;
import org.unidal.helper.Threads;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

public class PeriodTask
implements Threads.Task,
LogEnabled {
    private MessageAnalyzer m_analyzer;
    private MessageQueue m_queue;
    private long m_startTime;
    private int m_queueOverflow;
    private Logger m_logger;
    private int m_index;

    public void setIndex(int index) {
        this.m_index = index;
    }

    public PeriodTask(MessageAnalyzer analyzer, MessageQueue queue, long startTime) {
        this.m_analyzer = analyzer;
        this.m_queue = queue;
        this.m_startTime = startTime;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public boolean enqueue(MessageTree tree) {
        boolean result = this.m_queue.offer(tree);
        if (!result) {
            DefaultMessageTree t;
            ++this.m_queueOverflow;
            if (this.m_queueOverflow % 1000 == 0) {
                this.m_logger.warn(this.m_analyzer.getClass().getSimpleName() + " queue overflow number " + this.m_queueOverflow);
            }
            if (this.m_analyzer.getClass().getSimpleName().equals("DumpAnalyzer") && tree instanceof DefaultMessageTree && (t = (DefaultMessageTree)tree).getBuffer() != null) {
                t.getBuffer().release();
            }
        }
        return result;
    }

    public void finish() {
        try {
            this.m_analyzer.doCheckpoint(true);
            this.m_analyzer.destroy();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public MessageAnalyzer getAnalyzer() {
        return this.m_analyzer;
    }

    public String getName() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.m_startTime);
        return this.m_analyzer.getClass().getSimpleName() + "-" + cal.get(11) + "-" + this.m_index;
    }

    public void run() {
        try {
            this.m_analyzer.analyze(this.m_queue);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public void shutdown() {
        if (this.m_analyzer instanceof AbstractMessageAnalyzer) {
            ((AbstractMessageAnalyzer)this.m_analyzer).shutdown();
        }
    }
}

