/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analysis;

import com.dianping.cat.Cat;
import com.dianping.cat.analysis.MessageAnalyzer;
import com.dianping.cat.analysis.MessageAnalyzerManager;
import com.dianping.cat.analysis.MessageConsumer;
import com.dianping.cat.analysis.Period;
import com.dianping.cat.analysis.PeriodManager;
import com.dianping.cat.config.server.BlackListManager;
import com.dianping.cat.message.MessageProducer;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.statistic.ServerStatisticManager;
import java.util.List;
import org.unidal.helper.Threads;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealtimeConsumer
extends ContainerHolder
implements MessageConsumer,
Initializable,
LogEnabled {
    @Inject
    private MessageAnalyzerManager m_analyzerManager;
    @Inject
    private ServerStatisticManager m_serverStateManager;
    @Inject
    private BlackListManager m_blackListManager;
    private PeriodManager m_periodManager;
    private long m_black = -1L;
    private Logger m_logger;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;

    @Override
    public void consume(MessageTree tree) {
        String ip;
        String domain = tree.getDomain();
        if (!this.m_blackListManager.isBlack(domain, ip = tree.getIpAddress())) {
            long timestamp = tree.getMessage().getTimestamp();
            Period period = this.m_periodManager.findPeriod(timestamp);
            if (period != null) {
                period.distribute(tree);
            } else {
                this.m_serverStateManager.addNetworkTimeError(1L);
            }
        } else {
            ++this.m_black;
            if (this.m_black % 1000L == 0L) {
                Cat.logEvent((String)"Discard", (String)domain);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCheckpoint() {
        this.m_logger.info("starting do checkpoint.");
        MessageProducer cat = Cat.getProducer();
        Transaction t = cat.newTransaction("Checkpoint", this.getClass().getSimpleName());
        try {
            long currentStartTime = this.getCurrentStartTime();
            Period period = this.m_periodManager.findPeriod(currentStartTime);
            for (MessageAnalyzer analyzer : period.getAnalzyers()) {
                try {
                    analyzer.doCheckpoint(false);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            t.setStatus("0");
        }
        catch (RuntimeException e) {
            cat.logError((Throwable)e);
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
        this.m_logger.info("end do checkpoint.");
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public List<MessageAnalyzer> getCurrentAnalyzer(String name) {
        long currentStartTime = this.getCurrentStartTime();
        Period period = this.m_periodManager.findPeriod(currentStartTime);
        if (period != null) {
            return period.getAnalyzer(name);
        }
        return null;
    }

    private long getCurrentStartTime() {
        long now = System.currentTimeMillis();
        long time = now - now % 3600000L;
        return time;
    }

    public List<MessageAnalyzer> getLastAnalyzer(String name) {
        long lastStartTime = this.getCurrentStartTime() - 3600000L;
        Period period = this.m_periodManager.findPeriod(lastStartTime);
        return period == null ? null : period.getAnalyzer(name);
    }

    public void initialize() throws InitializationException {
        this.m_periodManager = new PeriodManager(3600000L, this.m_analyzerManager, this.m_serverStateManager, this.m_logger);
        this.m_periodManager.init();
        Threads.forGroup((String)"cat").start((Runnable)((Object)this.m_periodManager));
    }
}

