/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analysis;

import com.dianping.cat.analysis.MessageHandler;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import com.dianping.cat.statistic.ServerStatisticManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

public final class TcpSocketReceiver
implements LogEnabled {
    @Inject(type=MessageCodec.class, value={"plain-text"})
    private MessageCodec m_codec;
    @Inject
    private MessageHandler m_handler;
    @Inject
    protected ServerConfigManager m_serverConfigManager;
    @Inject
    private ServerStatisticManager m_serverStateManager;
    private ChannelFuture m_future;
    private EventLoopGroup m_bossGroup;
    private EventLoopGroup m_workerGroup;
    private Logger m_logger;
    private int m_port = 2280;
    private volatile long m_processCount;

    public synchronized void destory() {
        try {
            this.m_logger.info("start shutdown socket, port " + this.m_port);
            this.m_future.channel().closeFuture();
            this.m_bossGroup.shutdownGracefully();
            this.m_workerGroup.shutdownGracefully();
            this.m_logger.info("shutdown socket success");
        }
        catch (Exception e) {
            this.m_logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    protected boolean getOSMatches(String osNamePrefix) {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return os.startsWith(osNamePrefix);
    }

    public void init() {
        try {
            this.startServer(this.m_port);
        }
        catch (Throwable e) {
            this.m_logger.error(e.getMessage(), e);
        }
    }

    public synchronized void startServer(int port) throws InterruptedException {
        boolean linux = this.getOSMatches("Linux") || this.getOSMatches("LINUX");
        int threads = 24;
        ServerBootstrap bootstrap = new ServerBootstrap();
        this.m_bossGroup = linux ? new EpollEventLoopGroup(threads) : new NioEventLoopGroup(threads);
        this.m_workerGroup = linux ? new EpollEventLoopGroup(threads) : new NioEventLoopGroup(threads);
        bootstrap.group(this.m_bossGroup, this.m_workerGroup);
        bootstrap.channel(linux ? EpollServerSocketChannel.class : NioServerSocketChannel.class);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decode", (ChannelHandler)new MessageDecoder());
            }
        });
        bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        try {
            this.m_future = bootstrap.bind(port).sync();
            this.m_logger.info("start netty server!");
        }
        catch (Exception e) {
            this.m_logger.error("Started Netty Server Failed:" + port, (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MessageDecoder
    extends ByteToMessageDecoder {
        protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
            if (buffer.readableBytes() < 4) {
                return;
            }
            buffer.markReaderIndex();
            int length = buffer.readInt();
            buffer.resetReaderIndex();
            if (buffer.readableBytes() < length + 4) {
                return;
            }
            try {
                if (length > 0) {
                    ByteBuf readBytes = buffer.readBytes(length + 4);
                    readBytes.markReaderIndex();
                    readBytes.readInt();
                    DefaultMessageTree tree = (DefaultMessageTree)TcpSocketReceiver.this.m_codec.decode(readBytes);
                    readBytes.resetReaderIndex();
                    tree.setBuffer(readBytes);
                    TcpSocketReceiver.this.m_handler.handle((MessageTree)tree);
                    TcpSocketReceiver.this.m_processCount++;
                    long flag = TcpSocketReceiver.this.m_processCount % 1000L;
                    if (flag == 0L) {
                        TcpSocketReceiver.this.m_serverStateManager.addMessageTotal(1000L);
                    }
                } else {
                    buffer.readBytes(length);
                }
            }
            catch (Exception e) {
                TcpSocketReceiver.this.m_serverStateManager.addMessageTotalLoss(1L);
                TcpSocketReceiver.this.m_logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

