/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config;

import com.dianping.cat.config.AggregationMessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieTreeNode {
    private Map<TrieTreeKey, TrieTreeNode> m_childMap = new HashMap<TrieTreeKey, TrieTreeNode>();
    private Map<String, AggregationMessageFormat> m_formatMap = new HashMap<String, AggregationMessageFormat>();

    public void addFormat(String key, AggregationMessageFormat format) {
        this.m_formatMap.put(key, format);
    }

    public void addTreeNode(char ch, boolean isPrefix, TrieTreeNode node) {
        TrieTreeKey key = new TrieTreeKey(ch, isPrefix);
        this.m_childMap.put(key, node);
    }

    public TrieTreeNode getChildNode(char ch, boolean isPrefix) {
        TrieTreeKey key = new TrieTreeKey(ch, isPrefix);
        return this.m_childMap.get(key);
    }

    public Map<String, AggregationMessageFormat> getFormatMap() {
        return this.m_formatMap;
    }

    public String toString() {
        return "TrieTreeNode [m_childMap=" + this.m_childMap + ", m_formatList=" + this.m_formatMap + "]";
    }

    class TrieTreeKey {
        char m_ch;
        boolean m_isPrefix;

        public TrieTreeKey(char ch, boolean isPrefix) {
            this.m_ch = ch;
            this.m_isPrefix = isPrefix;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TrieTreeKey other = (TrieTreeKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.m_ch != other.m_ch) {
                return false;
            }
            return this.m_isPrefix == other.m_isPrefix;
        }

        private TrieTreeNode getOuterType() {
            return TrieTreeNode.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.m_ch;
            result = 31 * result + (this.m_isPrefix ? 1231 : 1237);
            return result;
        }

        public String toString() {
            return "TrieTreeKey [m_ch=" + this.m_ch + ", m_isPrefix=" + this.m_isPrefix + "]";
        }
    }
}

