/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.app.command;

import com.dianping.cat.Cat;
import com.dianping.cat.config.app.command.CommandFormatHandler;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.configuration.app.command.entity.Command;
import com.dianping.cat.configuration.app.command.entity.CommandFormat;
import com.dianping.cat.configuration.app.command.entity.Rule;
import com.dianping.cat.configuration.app.command.transform.DefaultSaxParser;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandFormatConfigManager
implements Initializable {
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    protected CommandFormatHandler m_handler;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private static final String CONFIG_NAME = "app-command-format-config";
    private volatile CommandFormat m_urlFormat;
    private Map<String, Rule> m_map = new HashMap<String, Rule>();
    private long m_modifyTime;
    public static final int PROBLEM_TYPE = 3;

    private String buildKey(int type, String pattern) {
        return type + ":" + pattern;
    }

    public CommandFormat getUrlFormat() {
        return this.m_urlFormat;
    }

    public List<String> handle(int type, String command) {
        String format = this.m_handler.handle(type, command);
        String key = this.buildKey(type, format);
        ArrayList<String> result = new ArrayList<String>();
        Rule rule = this.m_map.get(key);
        if (rule != null) {
            for (Command c : rule.getCommands()) {
                result.add(c.getId());
            }
        }
        if (result.isEmpty()) {
            result.add(command);
        }
        return result;
    }

    public void initialize() {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            this.m_configId = config.getId();
            this.refreshData(config);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.refreshData(config);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_urlFormat == null) {
            this.m_urlFormat = new CommandFormat();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_urlFormat = DefaultSaxParser.parse(xml);
            boolean result = this.storeConfig();
            return result;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    private void refreshData(Config config) throws SAXException, IOException {
        HashMap<String, Rule> map = new HashMap<String, Rule>();
        String content = config.getContent();
        Date modifyDate = config.getModifyDate();
        long modifyTime = modifyDate == null ? System.currentTimeMillis() : modifyDate.getTime();
        CommandFormat format = DefaultSaxParser.parse(content);
        for (Rule rule : format.getRules()) {
            int type = rule.getType();
            String pattern = rule.getPattern();
            String key = this.buildKey(type, pattern);
            map.put(key, rule);
        }
        this.m_map = map;
        this.m_urlFormat = format;
        this.m_handler.register(this.m_urlFormat.getRules());
        this.m_modifyTime = modifyTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUrlFormatConfig() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        CommandFormatConfigManager commandFormatConfigManager = this;
        synchronized (commandFormatConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                this.refreshData(config);
            }
        }
    }

    public void setConfigDao(ConfigDao configDao) {
        this.m_configDao = configDao;
    }

    private boolean storeConfig() {
        try {
            Config config = this.m_configDao.createLocal();
            config.setId(this.m_configId);
            config.setKeyId(this.m_configId);
            config.setName(CONFIG_NAME);
            config.setContent(this.m_urlFormat.toString());
            this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public class ConfigReloadTask
    implements Threads.Task {
        public String getName() {
            return "App-Rule-Config-Reload";
        }

        public void run() {
            boolean active = true;
            while (active) {
                try {
                    CommandFormatConfigManager.this.refreshUrlFormatConfig();
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    active = false;
                }
            }
        }

        public void shutdown() {
        }
    }
}

