/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.app.command;

import com.dianping.cat.config.AggregationMessageFormat;
import com.dianping.cat.config.CompositeFormat;
import com.dianping.cat.config.TrieTreeNode;
import com.dianping.cat.config.app.command.CommandFormatHandler;
import com.dianping.cat.configuration.app.command.entity.Rule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommandFormatlHandler
implements CommandFormatHandler,
LogEnabled {
    private Map<Integer, TrieTreeNode> m_formats = new HashMap<Integer, TrieTreeNode>();
    protected Logger m_logger;

    private void buildFormatTree(TrieTreeNode tree, char[] prefix, char[] suffix, AggregationMessageFormat format) {
        TrieTreeNode node;
        int i;
        if (prefix.length == 0 && suffix.length == 0) {
            tree.addFormat("", format);
            return;
        }
        boolean isPrefix = true;
        int sIndex = 0;
        int eIndex = 0;
        TrieTreeNode sCurrent = tree;
        TrieTreeNode eCurrent = tree;
        if (prefix.length != 0) {
            for (i = 0; i < prefix.length; ++i) {
                node = sCurrent.getChildNode(prefix[i], true);
                if (node == null) {
                    node = new TrieTreeNode();
                    sCurrent.addTreeNode(prefix[i], true, node);
                    ++sIndex;
                }
                sCurrent = node;
            }
        }
        if (suffix.length != 0) {
            for (i = suffix.length - 1; i >= 0; --i) {
                node = eCurrent.getChildNode(suffix[i], false);
                if (node == null) {
                    node = new TrieTreeNode();
                    eCurrent.addTreeNode(suffix[i], false, node);
                    ++eIndex;
                }
                eCurrent = node;
            }
        }
        if (sIndex > eIndex) {
            isPrefix = true;
        } else if (sIndex < eIndex) {
            isPrefix = false;
        } else {
            boolean bl = isPrefix = sCurrent.getFormatMap().size() < eCurrent.getFormatMap().size();
        }
        if (isPrefix) {
            sCurrent.addFormat(String.copyValueOf(suffix), format);
        } else {
            eCurrent.addFormat(String.copyValueOf(prefix), format);
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private TrieTreeNode findOrCreateTrieTreeNodes(int type) {
        TrieTreeNode node = this.m_formats.get(type);
        if (node == null) {
            node = new TrieTreeNode();
            this.m_formats.put(type, node);
        }
        return node;
    }

    private TrieTreeNode getFormatTree(int type) {
        return this.m_formats.get(type);
    }

    @Override
    public String handle(int type, String input) {
        TrieTreeNode formatTree = this.getFormatTree(type);
        if (formatTree == null) {
            return input;
        }
        return this.parse(formatTree, input);
    }

    private String parse(TrieTreeNode formatTree, String input) {
        CompositeFormat cf;
        AggregationMessageFormat amf;
        String key;
        char[] cs = input.toCharArray();
        ArrayList<Map<String, AggregationMessageFormat>> sformatSet = new ArrayList<Map<String, AggregationMessageFormat>>();
        ArrayList<Map<String, AggregationMessageFormat>> eformatSet = new ArrayList<Map<String, AggregationMessageFormat>>();
        TrieTreeNode current = formatTree;
        for (int i = 0; i < cs.length; ++i) {
            sformatSet.add(current.getFormatMap());
            TrieTreeNode node = current.getChildNode(cs[i], true);
            if (node == null) {
                --i;
                break;
            }
            current = node;
        }
        current = formatTree;
        for (int j = cs.length - 1; j > 0; --j) {
            eformatSet.add(current.getFormatMap());
            TrieTreeNode node = current.getChildNode(cs[j], false);
            if (node == null) {
                ++j;
                break;
            }
            current = node;
        }
        for (Map map : sformatSet) {
            for (Map.Entry entry : map.entrySet()) {
                String output;
                key = (String)entry.getKey();
                if (!input.endsWith(key)) continue;
                amf = (AggregationMessageFormat)map.get(key);
                cf = new CompositeFormat(amf);
                try {
                    output = cf.parse(input);
                }
                catch (Exception e) {
                    continue;
                }
                return output;
            }
        }
        for (Map map : eformatSet) {
            for (Map.Entry entry : map.entrySet()) {
                String output;
                key = (String)entry.getKey();
                if (!input.startsWith(key)) continue;
                amf = (AggregationMessageFormat)map.get(key);
                cf = new CompositeFormat(amf);
                try {
                    output = cf.parse(input);
                }
                catch (Exception e) {
                    continue;
                }
                return output;
            }
        }
        return input;
    }

    @Override
    public void register(List<Rule> rules) {
        this.m_formats.clear();
        for (Rule rule : rules) {
            int index2;
            int index1;
            String format = rule.getPattern();
            if (format == null || format.isEmpty() || (index1 = format.indexOf(123)) == -1 || index1 == format.length() - 1 || (index2 = format.lastIndexOf(125)) == -1 || index2 < index1) continue;
            String key1 = format.substring(0, index1);
            String key2 = format.substring(index2 + 1);
            AggregationMessageFormat value = new AggregationMessageFormat(format);
            TrieTreeNode node = this.findOrCreateTrieTreeNodes(rule.getType());
            this.buildFormatTree(node, key1.toCharArray(), key2.toCharArray(), value);
        }
    }
}

