/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.server;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.configuration.server.black.entity.BlackList;
import com.dianping.cat.configuration.server.black.transform.DefaultSaxParser;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import java.io.IOException;
import java.util.Date;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;
import org.xml.sax.SAXException;

public class BlackListManager
implements Initializable,
LogEnabled {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private volatile BlackList m_blackList;
    private Logger m_logger;
    private long m_modifyTime;
    private static final String CONFIG_NAME = "blackList";

    public boolean isBlack(String domain, String ip) {
        return this.m_blackList.getDomainNames().contains(domain) || this.m_blackList.getIps().contains(ip);
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public BlackList getBlackList() {
        return this.m_blackList;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_blackList = DefaultSaxParser.parse(content);
            this.m_modifyTime = config.getModifyDate().getTime();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                Date now = new Date();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                config.setModifyDate(now);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_blackList = DefaultSaxParser.parse(content);
                this.m_modifyTime = now.getTime();
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_blackList == null) {
            this.m_blackList = new BlackList();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_blackList = DefaultSaxParser.parse(xml);
            boolean result = this.storeConfig();
            return result;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            this.m_logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshConfig() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        BlackListManager blackListManager = this;
        synchronized (blackListManager) {
            if (modifyTime > this.m_modifyTime) {
                BlackList blackList;
                String content = config.getContent();
                this.m_blackList = blackList = DefaultSaxParser.parse(content);
                this.m_modifyTime = modifyTime;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        BlackListManager blackListManager = this;
        synchronized (blackListManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_blackList.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

