/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.server;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.configuration.server.filter.entity.CrashLogDomain;
import com.dianping.cat.configuration.server.filter.entity.ServerFilterConfig;
import com.dianping.cat.configuration.server.filter.transform.DefaultSaxParser;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFilterConfigManager
implements Initializable {
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    protected ContentFetcher m_fetcher;
    private volatile ServerFilterConfig m_config;
    private int m_configId;
    private long m_modifyTime;
    private static final String CONFIG_NAME = "serverFilter";

    public boolean discardTransaction(String type, String name) {
        if ("Cache.web".equals(type) || "ABTest".equals(type)) {
            return true;
        }
        return this.m_config.getTransactionTypes().contains(type) && this.m_config.getTransactionNames().contains(name);
    }

    public ServerFilterConfig getConfig() {
        return this.m_config;
    }

    public Map<String, CrashLogDomain> getCrashLogDomains() {
        return this.m_config.getCrashLogDomains();
    }

    public Set<String> getUnusedDomains() {
        HashSet<String> unusedDomains = new HashSet<String>();
        unusedDomains.addAll(this.m_config.getCrashLogDomains().keySet());
        unusedDomains.addAll(this.m_config.getDomains());
        return unusedDomains;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_modifyTime = config.getModifyDate().getTime();
            this.m_config = DefaultSaxParser.parse(content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse(content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new ServerFilterConfig();
        }
        Threads.forGroup((String)"cat").start((Runnable)((Object)new ConfigReloadTask()));
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse(xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean isCrashLog(String domain) {
        return this.m_config.getCrashLogDomains().containsKey(domain);
    }

    public boolean storeConfig() {
        try {
            Config config = this.m_configDao.createLocal();
            config.setId(this.m_configId);
            config.setKeyId(this.m_configId);
            config.setName(CONFIG_NAME);
            config.setContent(this.m_config.toString());
            this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean validateDomain(String domain) {
        return !this.m_config.getDomains().contains(domain) && !this.m_config.getCrashLogDomains().containsKey(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshConfig() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        ServerFilterConfigManager serverFilterConfigManager = this;
        synchronized (serverFilterConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                ServerFilterConfig serverConfig;
                String content = config.getContent();
                this.m_config = serverConfig = DefaultSaxParser.parse(content);
                this.m_modifyTime = modifyTime;
            }
        }
    }

    public class ConfigReloadTask
    implements Threads.Task {
        public String getName() {
            return "Server-Filter-Config-Reload";
        }

        public void run() {
            boolean active = true;
            while (active) {
                try {
                    ServerFilterConfigManager.this.refreshConfig();
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    active = false;
                }
            }
        }

        public void shutdown() {
        }
    }
}

