/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.web.url;

import com.dianping.cat.config.AggregationMessageFormat;
import com.dianping.cat.config.CompositeFormat;
import com.dianping.cat.config.TrieTreeNode;
import com.dianping.cat.config.web.url.UrlPatternHandler;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUrlPatternHandler
implements UrlPatternHandler,
LogEnabled {
    private TrieTreeNode m_formatTree;
    protected Logger m_logger;

    private void buildFormatTree(TrieTreeNode tree, char[] prefix, char[] suffix, AggregationMessageFormat format) {
        TrieTreeNode node;
        int i;
        if (prefix.length == 0 && suffix.length == 0) {
            tree.addFormat("", format);
            return;
        }
        boolean isPrefix = true;
        int sIndex = 0;
        int eIndex = 0;
        TrieTreeNode sCurrent = tree;
        TrieTreeNode eCurrent = tree;
        if (prefix.length != 0) {
            for (i = 0; i < prefix.length; ++i) {
                node = sCurrent.getChildNode(prefix[i], true);
                if (node == null) {
                    node = new TrieTreeNode();
                    sCurrent.addTreeNode(prefix[i], true, node);
                    ++sIndex;
                }
                sCurrent = node;
            }
        }
        if (suffix.length != 0) {
            for (i = suffix.length - 1; i >= 0; --i) {
                node = eCurrent.getChildNode(suffix[i], false);
                if (node == null) {
                    node = new TrieTreeNode();
                    eCurrent.addTreeNode(suffix[i], false, node);
                    ++eIndex;
                }
                eCurrent = node;
            }
        }
        if (sIndex > eIndex) {
            isPrefix = true;
        } else if (sIndex < eIndex) {
            isPrefix = false;
        } else {
            boolean bl = isPrefix = sCurrent.getFormatMap().size() < eCurrent.getFormatMap().size();
        }
        if (isPrefix) {
            sCurrent.addFormat(String.copyValueOf(suffix), format);
        } else {
            eCurrent.addFormat(String.copyValueOf(prefix), format);
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public String handle(String input) {
        return this.parse(this.m_formatTree, input);
    }

    private String parse(TrieTreeNode formatTree, String input) {
        CompositeFormat cf;
        AggregationMessageFormat amf;
        String key;
        char[] cs = input.toCharArray();
        ArrayList<Map<String, AggregationMessageFormat>> sformatSet = new ArrayList<Map<String, AggregationMessageFormat>>();
        ArrayList<Map<String, AggregationMessageFormat>> eformatSet = new ArrayList<Map<String, AggregationMessageFormat>>();
        TrieTreeNode current = formatTree;
        for (int i = 0; i < cs.length; ++i) {
            sformatSet.add(current.getFormatMap());
            TrieTreeNode node = current.getChildNode(cs[i], true);
            if (node == null) {
                --i;
                break;
            }
            current = node;
        }
        current = formatTree;
        for (int j = cs.length - 1; j > 0; --j) {
            eformatSet.add(current.getFormatMap());
            TrieTreeNode node = current.getChildNode(cs[j], false);
            if (node == null) {
                ++j;
                break;
            }
            current = node;
        }
        for (Map map : sformatSet) {
            for (Map.Entry entry : map.entrySet()) {
                String output;
                key = (String)entry.getKey();
                if (!input.endsWith(key)) continue;
                amf = (AggregationMessageFormat)map.get(key);
                cf = new CompositeFormat(amf);
                try {
                    output = cf.parse(input);
                }
                catch (Exception e) {
                    continue;
                }
                return output;
            }
        }
        for (Map map : eformatSet) {
            for (Map.Entry entry : map.entrySet()) {
                String output;
                key = (String)entry.getKey();
                if (!input.startsWith(key)) continue;
                amf = (AggregationMessageFormat)map.get(key);
                cf = new CompositeFormat(amf);
                try {
                    output = cf.parse(input);
                }
                catch (Exception e) {
                    continue;
                }
                return output;
            }
        }
        return input;
    }

    @Override
    public void register(Collection<PatternItem> rules) {
        this.m_formatTree = new TrieTreeNode();
        for (PatternItem rule : rules) {
            int index2;
            int index1;
            String format = rule.getPattern();
            if (format == null || format.isEmpty() || (index1 = format.indexOf(123)) == -1 || index1 == format.length() - 1 || (index2 = format.lastIndexOf(125)) == -1 || index2 < index1) continue;
            String key1 = format.substring(0, index1);
            String key2 = format.substring(index2 + 1);
            AggregationMessageFormat value = new AggregationMessageFormat(format);
            this.buildFormatTree(this.m_formatTree, key1.toCharArray(), key2.toCharArray(), value);
        }
    }
}

