/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.command.transform;

import com.dianping.cat.configuration.app.command.entity.Command;
import com.dianping.cat.configuration.app.command.entity.CommandFormat;
import com.dianping.cat.configuration.app.command.entity.Rule;
import com.dianping.cat.configuration.app.command.transform.IMaker;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    @Override
    public Command buildCommand(Attributes attributes) {
        String id = attributes.getValue("id");
        Command command = new Command();
        if (id != null) {
            command.setId(id);
        }
        return command;
    }

    @Override
    public CommandFormat buildCommandFormat(Attributes attributes) {
        String picSmall = attributes.getValue("picSmall");
        String picMiddel = attributes.getValue("picMiddel");
        String picLarge = attributes.getValue("picLarge");
        CommandFormat commandFormat = new CommandFormat();
        if (picSmall != null) {
            commandFormat.setPicSmall(this.convert(Integer.class, picSmall, 0));
        }
        if (picMiddel != null) {
            commandFormat.setPicMiddel(this.convert(Integer.class, picMiddel, 0));
        }
        if (picLarge != null) {
            commandFormat.setPicLarge(this.convert(Integer.class, picLarge, 0));
        }
        return commandFormat;
    }

    @Override
    public Rule buildRule(Attributes attributes) {
        String pattern = attributes.getValue("pattern");
        String type = attributes.getValue("type");
        Rule rule = new Rule();
        if (pattern != null) {
            rule.setPattern(pattern);
        }
        if (type != null) {
            rule.setType(this.convert(Integer.class, type, 0));
        }
        return rule;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }
}

