/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.entity;

import com.dianping.cat.configuration.app.BaseEntity;
import com.dianping.cat.configuration.app.IVisitor;
import com.dianping.cat.configuration.app.entity.Item;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigItem
extends BaseEntity<ConfigItem> {
    private String m_id;
    private Map<Integer, Item> m_items = new LinkedHashMap<Integer, Item>();

    public ConfigItem() {
    }

    public ConfigItem(String id) {
        this.m_id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitConfigItem(this);
    }

    public ConfigItem addItem(Item item) {
        this.m_items.put(item.getId(), item);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigItem) {
            ConfigItem _o = (ConfigItem)obj;
            return this.equals(this.getId(), _o.getId());
        }
        return false;
    }

    public Item findItem(Integer id) {
        return this.m_items.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item findOrCreateItem(Integer id) {
        Item item = this.m_items.get(id);
        if (item == null) {
            Map<Integer, Item> map = this.m_items;
            synchronized (map) {
                item = this.m_items.get(id);
                if (item == null) {
                    item = new Item(id);
                    this.m_items.put(id, item);
                }
            }
        }
        return item;
    }

    public String getId() {
        return this.m_id;
    }

    public Map<Integer, Item> getItems() {
        return this.m_items;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(ConfigItem other) {
        this.assertAttributeEquals(other, "config-item", "id", this.m_id, other.getId());
    }

    public Item removeItem(Integer id) {
        return this.m_items.remove(id);
    }

    public ConfigItem setId(String id) {
        this.m_id = id;
        return this;
    }
}

