/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.speed.entity;

import com.dianping.cat.configuration.app.speed.BaseEntity;
import com.dianping.cat.configuration.app.speed.IVisitor;
import com.dianping.cat.configuration.app.speed.entity.Speed;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSpeedConfig
extends BaseEntity<AppSpeedConfig> {
    private Map<Integer, Speed> m_speeds = new LinkedHashMap<Integer, Speed>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitAppSpeedConfig(this);
    }

    public AppSpeedConfig addSpeed(Speed speed) {
        this.m_speeds.put(speed.getId(), speed);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AppSpeedConfig) {
            AppSpeedConfig _o = (AppSpeedConfig)obj;
            return this.equals(this.getSpeeds(), _o.getSpeeds());
        }
        return false;
    }

    public Speed findSpeed(int id) {
        return this.m_speeds.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Speed findOrCreateSpeed(int id) {
        Speed speed = this.m_speeds.get(id);
        if (speed == null) {
            Map<Integer, Speed> map = this.m_speeds;
            synchronized (map) {
                speed = this.m_speeds.get(id);
                if (speed == null) {
                    speed = new Speed(id);
                    this.m_speeds.put(id, speed);
                }
            }
        }
        return speed;
    }

    public Map<Integer, Speed> getSpeeds() {
        return this.m_speeds;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_speeds == null ? 0 : this.m_speeds.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(AppSpeedConfig other) {
    }

    public Speed removeSpeed(int id) {
        return this.m_speeds.remove(id);
    }
}

