/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.speed.transform;

import com.dianping.cat.configuration.app.speed.entity.AppSpeedConfig;
import com.dianping.cat.configuration.app.speed.entity.Speed;
import com.dianping.cat.configuration.app.speed.transform.IMaker;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    @Override
    public AppSpeedConfig buildAppSpeedConfig(Attributes attributes) {
        AppSpeedConfig appSpeedConfig = new AppSpeedConfig();
        return appSpeedConfig;
    }

    @Override
    public Speed buildSpeed(Attributes attributes) {
        String id = attributes.getValue("id");
        String page = attributes.getValue("page");
        String step = attributes.getValue("step");
        String title = attributes.getValue("title");
        String threshold = attributes.getValue("threshold");
        Speed speed = new Speed(id == null ? 0 : this.convert(Integer.class, id, 0));
        if (page != null) {
            speed.setPage(page);
        }
        if (step != null) {
            speed.setStep(this.convert(Integer.class, step, 0));
        }
        if (title != null) {
            speed.setTitle(title);
        }
        if (threshold != null) {
            speed.setThreshold(this.convert(Integer.class, threshold, 0));
        }
        return speed;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }
}

