/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.transform;

import com.dianping.cat.configuration.app.entity.AppConfig;
import com.dianping.cat.configuration.app.entity.Code;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.configuration.app.entity.ConfigItem;
import com.dianping.cat.configuration.app.entity.Item;
import com.dianping.cat.configuration.app.transform.ILinker;
import java.util.ArrayList;
import java.util.List;

public class DefaultLinker
implements ILinker {
    private boolean m_deferrable;
    private List<Runnable> m_deferedJobs = new ArrayList<Runnable>();

    public DefaultLinker(boolean deferrable) {
        this.m_deferrable = deferrable;
    }

    public void finish() {
        for (Runnable job : this.m_deferedJobs) {
            job.run();
        }
    }

    public boolean onCode(final AppConfig parent, final Code code) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addCode(code);
                }
            });
        } else {
            parent.addCode(code);
        }
        return true;
    }

    public boolean onCode(final Command parent, final Code code) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addCode(code);
                }
            });
        } else {
            parent.addCode(code);
        }
        return true;
    }

    public boolean onCommand(final AppConfig parent, final Command command) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addCommand(command);
                }
            });
        } else {
            parent.addCommand(command);
        }
        return true;
    }

    public boolean onConfigItem(final AppConfig parent, final ConfigItem configItem) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addConfigItem(configItem);
                }
            });
        } else {
            parent.addConfigItem(configItem);
        }
        return true;
    }

    public boolean onItem(final ConfigItem parent, final Item item) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addItem(item);
                }
            });
        } else {
            parent.addItem(item);
        }
        return true;
    }
}

