/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.black.transform;

import com.dianping.cat.configuration.server.black.IEntity;
import com.dianping.cat.configuration.server.black.entity.BlackList;
import com.dianping.cat.configuration.server.black.entity.Property;
import com.dianping.cat.configuration.server.black.transform.DefaultLinker;
import com.dianping.cat.configuration.server.black.transform.DefaultSaxMaker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static BlackList parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(BlackList.class, new InputSource(DefaultSaxParser.removeBOM(in)));
    }

    public static BlackList parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(BlackList.class, new InputSource(DefaultSaxParser.removeBOM(reader)));
    }

    public static BlackList parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(BlackList.class, new InputSource(new StringReader(DefaultSaxParser.removeBOM(xml))));
    }

    private static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(DefaultSaxParser.removeBOM(in)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(DefaultSaxParser.removeBOM(xml))));
    }

    private static <T> T removeBOM(T obj) throws IOException {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() != 0 && str.charAt(0) == '\ufeff') {
                return (T)str.substring(1);
            }
            return obj;
        }
        if (obj instanceof InputStream) {
            BufferedInputStream in = new BufferedInputStream((InputStream)obj);
            in.mark(3);
            if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
                in.reset();
            }
            return (T)in;
        }
        if (obj instanceof Reader) {
            BufferedReader in = new BufferedReader((Reader)obj);
            in.mark(1);
            if (in.read() != 65279) {
                in.reset();
            }
            return (T)in;
        }
        return obj;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = this.m_tags.pop();
            if (currentObj instanceof BlackList) {
                BlackList blackList = (BlackList)currentObj;
                if ("domain".equals(currentTag)) {
                    blackList.addDomain(this.getText());
                } else if ("ip".equals(currentTag)) {
                    blackList.addIp(this.getText());
                }
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForBlackList(BlackList parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("domain-names".equals(qName) || "domain".equals(qName) || "ips".equals(qName) || "ip".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("property".equals(qName)) {
            Property property = this.m_maker.buildProperty(attributes);
            this.m_linker.onProperty(parentObj, property);
            this.m_objs.push(property);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under black-list!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForProperty(Property parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("black-list".equals(qName)) {
            BlackList blackList;
            this.m_entity = blackList = this.m_maker.buildBlackList(attributes);
            this.m_objs.push(blackList);
            this.m_tags.push(qName);
        } else if ("property".equals(qName)) {
            Property property;
            this.m_entity = property = this.m_maker.buildProperty(attributes);
            this.m_objs.push(property);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof BlackList) {
                this.parseForBlackList((BlackList)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Property)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForProperty((Property)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

