/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.entity;

import com.dianping.cat.configuration.server.BaseEntity;
import com.dianping.cat.configuration.server.IVisitor;
import com.dianping.cat.configuration.server.entity.Domain;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongConfig
extends BaseEntity<LongConfig> {
    private Integer m_defaultUrlThreshold = 1000;
    private Integer m_defaultSqlThreshold = 100;
    private Integer m_defaultServiceThreshold = 50;
    private Map<String, Domain> m_domains = new LinkedHashMap<String, Domain>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitLongConfig(this);
    }

    public LongConfig addDomain(Domain domain) {
        this.m_domains.put(domain.getName(), domain);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongConfig) {
            LongConfig _o = (LongConfig)obj;
            if (!this.equals(this.getDefaultUrlThreshold(), _o.getDefaultUrlThreshold())) {
                return false;
            }
            if (!this.equals(this.getDefaultSqlThreshold(), _o.getDefaultSqlThreshold())) {
                return false;
            }
            if (!this.equals(this.getDefaultServiceThreshold(), _o.getDefaultServiceThreshold())) {
                return false;
            }
            return this.equals(this.getDomains(), _o.getDomains());
        }
        return false;
    }

    public Domain findDomain(String name) {
        return this.m_domains.get(name);
    }

    public Integer getDefaultServiceThreshold() {
        return this.m_defaultServiceThreshold;
    }

    public Integer getDefaultSqlThreshold() {
        return this.m_defaultSqlThreshold;
    }

    public Integer getDefaultUrlThreshold() {
        return this.m_defaultUrlThreshold;
    }

    public Map<String, Domain> getDomains() {
        return this.m_domains;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_defaultUrlThreshold == null ? 0 : this.m_defaultUrlThreshold.hashCode());
        hash = hash * 31 + (this.m_defaultSqlThreshold == null ? 0 : this.m_defaultSqlThreshold.hashCode());
        hash = hash * 31 + (this.m_defaultServiceThreshold == null ? 0 : this.m_defaultServiceThreshold.hashCode());
        hash = hash * 31 + (this.m_domains == null ? 0 : this.m_domains.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(LongConfig other) {
        if (other.getDefaultUrlThreshold() != null) {
            this.m_defaultUrlThreshold = other.getDefaultUrlThreshold();
        }
        if (other.getDefaultSqlThreshold() != null) {
            this.m_defaultSqlThreshold = other.getDefaultSqlThreshold();
        }
        if (other.getDefaultServiceThreshold() != null) {
            this.m_defaultServiceThreshold = other.getDefaultServiceThreshold();
        }
    }

    public Domain removeDomain(String name) {
        return this.m_domains.remove(name);
    }

    public LongConfig setDefaultServiceThreshold(Integer defaultServiceThreshold) {
        this.m_defaultServiceThreshold = defaultServiceThreshold;
        return this;
    }

    public LongConfig setDefaultSqlThreshold(Integer defaultSqlThreshold) {
        this.m_defaultSqlThreshold = defaultSqlThreshold;
        return this;
    }

    public LongConfig setDefaultUrlThreshold(Integer defaultUrlThreshold) {
        this.m_defaultUrlThreshold = defaultUrlThreshold;
        return this;
    }
}

