/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.entity;

import com.dianping.cat.configuration.server.BaseEntity;
import com.dianping.cat.configuration.server.IVisitor;
import com.dianping.cat.configuration.server.entity.ConsoleConfig;
import com.dianping.cat.configuration.server.entity.ConsumerConfig;
import com.dianping.cat.configuration.server.entity.Ldap;
import com.dianping.cat.configuration.server.entity.Property;
import com.dianping.cat.configuration.server.entity.StorageConfig;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfig
extends BaseEntity<ServerConfig> {
    private Boolean m_localMode = true;
    private Boolean m_jobMachine = false;
    private StorageConfig m_storage;
    private ConsumerConfig m_consumer;
    private ConsoleConfig m_console;
    private Boolean m_alertMachine = false;
    private Boolean m_hdfsMachine = true;
    private Boolean m_sendMachine = true;
    private Ldap m_ldap;
    private Map<String, Property> m_properties = new LinkedHashMap<String, Property>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitConfig(this);
    }

    public ServerConfig addProperty(Property property) {
        this.m_properties.put(property.getName(), property);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerConfig) {
            ServerConfig _o = (ServerConfig)obj;
            if (!this.equals(this.getLocalMode(), _o.getLocalMode())) {
                return false;
            }
            if (!this.equals(this.getJobMachine(), _o.getJobMachine())) {
                return false;
            }
            if (!this.equals(this.getStorage(), _o.getStorage())) {
                return false;
            }
            if (!this.equals(this.getConsumer(), _o.getConsumer())) {
                return false;
            }
            if (!this.equals(this.getConsole(), _o.getConsole())) {
                return false;
            }
            if (!this.equals(this.getAlertMachine(), _o.getAlertMachine())) {
                return false;
            }
            if (!this.equals(this.getHdfsMachine(), _o.getHdfsMachine())) {
                return false;
            }
            if (!this.equals(this.getSendMachine(), _o.getSendMachine())) {
                return false;
            }
            if (!this.equals(this.getLdap(), _o.getLdap())) {
                return false;
            }
            return this.equals(this.getProperties(), _o.getProperties());
        }
        return false;
    }

    public Property findProperty(String name) {
        return this.m_properties.get(name);
    }

    public Boolean getAlertMachine() {
        return this.m_alertMachine;
    }

    public ConsoleConfig getConsole() {
        return this.m_console;
    }

    public ConsumerConfig getConsumer() {
        return this.m_consumer;
    }

    public Boolean getHdfsMachine() {
        return this.m_hdfsMachine;
    }

    public Boolean getJobMachine() {
        return this.m_jobMachine;
    }

    public Ldap getLdap() {
        return this.m_ldap;
    }

    public Boolean getLocalMode() {
        return this.m_localMode;
    }

    public Map<String, Property> getProperties() {
        return this.m_properties;
    }

    public Boolean getSendMachine() {
        return this.m_sendMachine;
    }

    public StorageConfig getStorage() {
        return this.m_storage;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_localMode == null ? 0 : this.m_localMode.hashCode());
        hash = hash * 31 + (this.m_jobMachine == null ? 0 : this.m_jobMachine.hashCode());
        hash = hash * 31 + (this.m_storage == null ? 0 : this.m_storage.hashCode());
        hash = hash * 31 + (this.m_consumer == null ? 0 : this.m_consumer.hashCode());
        hash = hash * 31 + (this.m_console == null ? 0 : this.m_console.hashCode());
        hash = hash * 31 + (this.m_alertMachine == null ? 0 : this.m_alertMachine.hashCode());
        hash = hash * 31 + (this.m_hdfsMachine == null ? 0 : this.m_hdfsMachine.hashCode());
        hash = hash * 31 + (this.m_sendMachine == null ? 0 : this.m_sendMachine.hashCode());
        hash = hash * 31 + (this.m_ldap == null ? 0 : this.m_ldap.hashCode());
        hash = hash * 31 + (this.m_properties == null ? 0 : this.m_properties.hashCode());
        return hash;
    }

    public boolean isAlertMachine() {
        return this.m_alertMachine != null && this.m_alertMachine != false;
    }

    public boolean isHdfsMachine() {
        return this.m_hdfsMachine != null && this.m_hdfsMachine != false;
    }

    public boolean isJobMachine() {
        return this.m_jobMachine != null && this.m_jobMachine != false;
    }

    public boolean isLocalMode() {
        return this.m_localMode != null && this.m_localMode != false;
    }

    public boolean isSendMachine() {
        return this.m_sendMachine != null && this.m_sendMachine != false;
    }

    @Override
    public void mergeAttributes(ServerConfig other) {
        if (other.getLocalMode() != null) {
            this.m_localMode = other.getLocalMode();
        }
        if (other.getJobMachine() != null) {
            this.m_jobMachine = other.getJobMachine();
        }
        if (other.getAlertMachine() != null) {
            this.m_alertMachine = other.getAlertMachine();
        }
        if (other.getHdfsMachine() != null) {
            this.m_hdfsMachine = other.getHdfsMachine();
        }
        if (other.getSendMachine() != null) {
            this.m_sendMachine = other.getSendMachine();
        }
    }

    public Property removeProperty(String name) {
        return this.m_properties.remove(name);
    }

    public ServerConfig setAlertMachine(Boolean alertMachine) {
        this.m_alertMachine = alertMachine;
        return this;
    }

    public ServerConfig setConsole(ConsoleConfig console) {
        this.m_console = console;
        return this;
    }

    public ServerConfig setConsumer(ConsumerConfig consumer) {
        this.m_consumer = consumer;
        return this;
    }

    public ServerConfig setHdfsMachine(Boolean hdfsMachine) {
        this.m_hdfsMachine = hdfsMachine;
        return this;
    }

    public ServerConfig setJobMachine(Boolean jobMachine) {
        this.m_jobMachine = jobMachine;
        return this;
    }

    public ServerConfig setLdap(Ldap ldap) {
        this.m_ldap = ldap;
        return this;
    }

    public ServerConfig setLocalMode(Boolean localMode) {
        this.m_localMode = localMode;
        return this;
    }

    public ServerConfig setSendMachine(Boolean sendMachine) {
        this.m_sendMachine = sendMachine;
        return this;
    }

    public ServerConfig setStorage(StorageConfig storage) {
        this.m_storage = storage;
        return this;
    }
}

