/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.transform;

import com.dianping.cat.configuration.server.entity.ConsoleConfig;
import com.dianping.cat.configuration.server.entity.ConsumerConfig;
import com.dianping.cat.configuration.server.entity.Domain;
import com.dianping.cat.configuration.server.entity.HdfsConfig;
import com.dianping.cat.configuration.server.entity.Ldap;
import com.dianping.cat.configuration.server.entity.LongConfig;
import com.dianping.cat.configuration.server.entity.Property;
import com.dianping.cat.configuration.server.entity.ServerConfig;
import com.dianping.cat.configuration.server.entity.StorageConfig;
import com.dianping.cat.configuration.server.transform.ILinker;
import java.util.ArrayList;
import java.util.List;

public class DefaultLinker
implements ILinker {
    private boolean m_deferrable;
    private List<Runnable> m_deferedJobs = new ArrayList<Runnable>();

    public DefaultLinker(boolean deferrable) {
        this.m_deferrable = deferrable;
    }

    public void finish() {
        for (Runnable job : this.m_deferedJobs) {
            job.run();
        }
    }

    public boolean onConsole(ServerConfig parent, ConsoleConfig console) {
        parent.setConsole(console);
        return true;
    }

    public boolean onConsumer(ServerConfig parent, ConsumerConfig consumer) {
        parent.setConsumer(consumer);
        return true;
    }

    public boolean onDomain(final LongConfig parent, final Domain domain) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addDomain(domain);
                }
            });
        } else {
            parent.addDomain(domain);
        }
        return true;
    }

    public boolean onHdfs(final StorageConfig parent, final HdfsConfig hdfs) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addHdfs(hdfs);
                }
            });
        } else {
            parent.addHdfs(hdfs);
        }
        return true;
    }

    public boolean onLdap(ServerConfig parent, Ldap ldap) {
        parent.setLdap(ldap);
        return true;
    }

    public boolean onLongConfig(ConsumerConfig parent, LongConfig longConfig) {
        parent.setLongConfig(longConfig);
        return true;
    }

    public boolean onProperty(final ServerConfig parent, final Property property) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addProperty(property);
                }
            });
        } else {
            parent.addProperty(property);
        }
        return true;
    }

    public boolean onProperty(final StorageConfig parent, final Property property) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addProperty(property);
                }
            });
        } else {
            parent.addProperty(property);
        }
        return true;
    }

    public boolean onStorage(ServerConfig parent, StorageConfig storage) {
        parent.setStorage(storage);
        return true;
    }
}

