/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.transform;

import com.dianping.cat.configuration.server.IVisitor;
import com.dianping.cat.configuration.server.entity.ConsoleConfig;
import com.dianping.cat.configuration.server.entity.ConsumerConfig;
import com.dianping.cat.configuration.server.entity.Domain;
import com.dianping.cat.configuration.server.entity.HdfsConfig;
import com.dianping.cat.configuration.server.entity.Ldap;
import com.dianping.cat.configuration.server.entity.LongConfig;
import com.dianping.cat.configuration.server.entity.Property;
import com.dianping.cat.configuration.server.entity.ServerConfig;
import com.dianping.cat.configuration.server.entity.StorageConfig;
import java.util.Stack;

public class DefaultValidator
implements IVisitor {
    private Path m_path = new Path();

    protected void assertRequired(String name, Object value) {
        if (value == null) {
            throw new RuntimeException(String.format("%s at path(%s) is required!", name, this.m_path));
        }
    }

    public void visitConfig(ServerConfig config) {
        this.m_path.down("config");
        this.visitConfigChildren(config);
        this.m_path.up("config");
    }

    protected void visitConfigChildren(ServerConfig config) {
        if (config.getStorage() != null) {
            this.visitStorage(config.getStorage());
        }
        if (config.getConsumer() != null) {
            this.visitConsumer(config.getConsumer());
        }
        if (config.getConsole() != null) {
            this.visitConsole(config.getConsole());
        }
        if (config.getLdap() != null) {
            this.visitLdap(config.getLdap());
        }
        for (Property property : config.getProperties().values()) {
            this.visitProperty(property);
        }
    }

    public void visitConsole(ConsoleConfig console) {
    }

    public void visitConsumer(ConsumerConfig consumer) {
        this.m_path.down("consumer");
        this.visitConsumerChildren(consumer);
        this.m_path.up("consumer");
    }

    protected void visitConsumerChildren(ConsumerConfig consumer) {
        if (consumer.getLongConfig() != null) {
            this.visitLongConfig(consumer.getLongConfig());
        }
    }

    public void visitDomain(Domain domain) {
        this.m_path.down("domain");
        this.assertRequired("name", domain.getName());
        this.m_path.up("domain");
    }

    public void visitHdfs(HdfsConfig hdfs) {
        this.m_path.down("hdfs");
        this.assertRequired("id", hdfs.getId());
        this.m_path.up("hdfs");
    }

    public void visitLdap(Ldap ldap) {
    }

    public void visitLongConfig(LongConfig longConfig) {
        this.m_path.down("long-config");
        this.visitLongConfigChildren(longConfig);
        this.m_path.up("long-config");
    }

    protected void visitLongConfigChildren(LongConfig longConfig) {
        for (Domain domain : longConfig.getDomains().values()) {
            this.visitDomain(domain);
        }
    }

    public void visitProperty(Property property) {
        this.m_path.down("property");
        this.assertRequired("name", property.getName());
        this.m_path.up("property");
    }

    public void visitStorage(StorageConfig storage) {
        this.m_path.down("storage");
        this.visitStorageChildren(storage);
        this.m_path.up("storage");
    }

    protected void visitStorageChildren(StorageConfig storage) {
        for (HdfsConfig hdfs : storage.getHdfses().values()) {
            this.visitHdfs(hdfs);
        }
        this.m_path.down("properties");
        for (Property property : storage.getProperties().values()) {
            this.visitProperty(property);
        }
        this.m_path.up("properties");
    }

    static class Path {
        private Stack<String> m_sections = new Stack();

        Path() {
        }

        public Path down(String nextSection) {
            this.m_sections.push(nextSection);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String section : this.m_sections) {
                sb.append('/').append(section);
            }
            return sb.toString();
        }

        public Path up(String currentSection) {
            if (this.m_sections.isEmpty() || !this.m_sections.peek().equals(currentSection)) {
                throw new RuntimeException("INTERNAL ERROR: stack mismatched!");
            }
            this.m_sections.pop();
            return this;
        }
    }
}

