/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.web.url.transform;

import com.dianping.cat.configuration.web.url.IVisitor;
import com.dianping.cat.configuration.web.url.entity.Code;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import com.dianping.cat.configuration.web.url.entity.UrlPattern;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DefaultNativeBuilder
implements IVisitor {
    private IVisitor m_visitor;
    private DataOutputStream m_out;

    public DefaultNativeBuilder(OutputStream out) {
        this(out, null);
    }

    public DefaultNativeBuilder(OutputStream out, IVisitor visitor) {
        this.m_out = new DataOutputStream(out);
        this.m_visitor = visitor == null ? this : visitor;
    }

    public static byte[] build(UrlPattern urlPattern) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        DefaultNativeBuilder.build(urlPattern, out);
        return out.toByteArray();
    }

    public static void build(UrlPattern urlPattern, OutputStream out) {
        urlPattern.accept(new DefaultNativeBuilder(out));
    }

    public void visitCode(Code code) {
        if (code.getId() != null) {
            this.writeTag(1, 1);
            this.writeInt(code.getId());
        }
        if (code.getName() != null) {
            this.writeTag(2, 1);
            this.writeString(code.getName());
        }
        if (code.getStatus() != null) {
            this.writeTag(3, 1);
            this.writeInt(code.getStatus());
        }
        this.writeTag(63, 3);
    }

    public void visitPatternItem(PatternItem patternItem) {
        if (patternItem.getGroup() != null) {
            this.writeTag(1, 1);
            this.writeString(patternItem.getGroup());
        }
        if (patternItem.getName() != null) {
            this.writeTag(2, 1);
            this.writeString(patternItem.getName());
        }
        if (patternItem.getPattern() != null) {
            this.writeTag(3, 1);
            this.writeString(patternItem.getPattern());
        }
        if (patternItem.getDomain() != null) {
            this.writeTag(4, 1);
            this.writeString(patternItem.getDomain());
        }
        this.writeTag(5, 0);
        this.writeInt(patternItem.getId());
        this.writeTag(63, 3);
    }

    public void visitUrlPattern(UrlPattern urlPattern) {
        this.writeTag(63, 0);
        if (!urlPattern.getPatternItems().isEmpty()) {
            this.writeTag(33, 2);
            this.writeInt(urlPattern.getPatternItems().size());
            for (PatternItem patternItem : urlPattern.getPatternItems().values()) {
                patternItem.accept(this.m_visitor);
            }
        }
        if (!urlPattern.getCodes().isEmpty()) {
            this.writeTag(34, 2);
            this.writeInt(urlPattern.getCodes().size());
            for (Code code : urlPattern.getCodes().values()) {
                code.accept(this.m_visitor);
            }
        }
        this.writeTag(63, 3);
    }

    private void writeInt(int value) {
        try {
            this.writeVarint((long)value & 0xFFFFFFFFL);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeString(String value) {
        try {
            this.m_out.writeUTF(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTag(int field, int type) {
        try {
            this.m_out.writeByte((field << 2) + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVarint(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.m_out.writeByte((byte)value);
                return;
            }
            this.m_out.writeByte((byte)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }
}

