/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortHelper {
    private static DomainComparator s_domainComparator = new DomainComparator();
    private static IpComparator s_ipComparator = new IpComparator();

    public static List<String> sortDomain(Collection<String> strs) {
        if (strs == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(strs);
        Collections.sort(result, s_domainComparator);
        return result;
    }

    public static List<String> sortIpAddress(Collection<String> strs) {
        if (strs == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(strs);
        Collections.sort(result, s_ipComparator);
        return result;
    }

    public static <K, V> Map<K, V> sortMap(Map<K, V> map, Comparator<Map.Entry<K, V>> compator) {
        LinkedHashMap result = new LinkedHashMap();
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, compator);
        for (Map.Entry entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IpComparator
    implements Comparator<String> {
        @Override
        public int compare(String d1, String d2) {
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null) {
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            if ("All".equals(d1)) {
                return -1;
            }
            if ("All".equals(d2)) {
                return 1;
            }
            return d1.compareTo(d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DomainComparator
    implements Comparator<String> {
        @Override
        public int compare(String d1, String d2) {
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null) {
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            if ("cat".equals(d1)) {
                return 1;
            }
            if ("cat".equals(d2)) {
                return -1;
            }
            if ("All".equals(d1)) {
                return -1;
            }
            if ("All".equals(d2)) {
                return 1;
            }
            return d1.compareTo(d2);
        }
    }
}

