/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.codec;

import com.dianping.cat.message.Event;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Trace;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.codec.BufferWriter;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMessageCodec
implements MessageCodec,
Initializable {
    public static final String ID = "html";
    private static final String VERSION = "HT2";
    @Inject
    private BufferWriter m_writer;
    @Inject
    private String m_logViewPrefix = "/cat/r/m/";
    private BufferHelper m_bufferHelper;
    private DateHelper m_dateHelper = new DateHelper();

    public MessageTree decode(ByteBuf buf) {
        throw new UnsupportedOperationException("HtmlMessageCodec only supports one-way encoding!");
    }

    public void decode(ByteBuf buf, MessageTree tree) {
        throw new UnsupportedOperationException("HtmlMessageCodec only supports one-way encoding!");
    }

    public void encode(MessageTree tree, ByteBuf buf) {
        int count = 0;
        int index = buf.writerIndex();
        BufferHelper helper = this.m_bufferHelper;
        buf.writeInt(0);
        count += helper.table1(buf);
        count += helper.crlf(buf);
        count += this.encodeHeader(tree, buf);
        if (tree.getMessage() != null) {
            count += this.encodeMessage(tree, tree.getMessage(), buf, 0, new LineCounter());
        }
        buf.setInt(index, count += helper.table2(buf));
    }

    protected int encodeFooter(MessageTree tree, ByteBuf buf) {
        return 0;
    }

    protected int encodeHeader(MessageTree tree, ByteBuf buf) {
        BufferHelper helper = this.m_bufferHelper;
        StringBuilder sb = new StringBuilder(1024);
        String parentMessageId = tree.getParentMessageId();
        String rootMessageId = tree.getRootMessageId();
        String domain = tree.getDomain();
        sb.append("<tr class=\"header\"><td colspan=5>");
        if (rootMessageId != null && !rootMessageId.equalsIgnoreCase("null")) {
            sb.append(String.format("<a href='%s?domain=%s'>RootLogview</a>&nbsp;&nbsp;", rootMessageId, domain));
            if (!parentMessageId.equals(rootMessageId)) {
                sb.append(String.format("<a href='%s?domain=%s'>ParentLogview</a> ", parentMessageId, domain));
            }
        }
        sb.append(VERSION).append(" ").append(tree.getDomain()).append(" ");
        sb.append(tree.getHostName()).append(" ").append(tree.getIpAddress()).append(" ");
        sb.append(tree.getThreadGroupName()).append(" ").append(tree.getThreadId()).append(" ");
        sb.append(tree.getThreadName()).append(" ").append(tree.getMessageId()).append(" ");
        sb.append(parentMessageId).append(" ").append(rootMessageId).append(" ");
        sb.append(tree.getSessionToken()).append(" ");
        sb.append("</td></tr>");
        return helper.write(buf, sb.toString());
    }

    protected int encodeLine(MessageTree tree, Message message, ByteBuf buf, char type, Policy policy, int level, LineCounter counter) {
        BufferHelper helper = this.m_bufferHelper;
        int count = 0;
        if (counter != null) {
            counter.inc();
            count += helper.tr1(buf, counter.getCount() % 2 != 0 ? "odd" : "even");
        } else {
            count += helper.tr1(buf, null);
        }
        count += helper.td1(buf);
        count += helper.nbsp(buf, level * 2);
        count += helper.write(buf, (byte)type);
        if (type == 'T' && message instanceof Transaction) {
            long duration = ((Transaction)message).getDurationInMillis();
            count += helper.write(buf, this.m_dateHelper.format(message.getTimestamp() + duration));
        } else {
            count += helper.write(buf, this.m_dateHelper.format(message.getTimestamp()));
        }
        count += helper.td2(buf);
        count += helper.td(buf, message.getType());
        count += helper.td(buf, message.getName());
        if (policy != Policy.WITHOUT_STATUS) {
            count = "0".equals(message.getStatus()) ? (count += helper.td(buf, "&nbsp;")) : (count += helper.td(buf, message.getStatus(), "class=\"error\""));
            Object data = message.getData();
            count += helper.td1(buf);
            if (policy == Policy.WITH_DURATION && message instanceof Transaction) {
                long durationInMicro = ((Transaction)message).getDurationInMicros();
                long durationInMillis = durationInMicro / 1000L;
                count = durationInMicro < 100L ? (count += helper.write(buf, String.format("%.2f", (double)durationInMicro / 1000.0))) : (durationInMicro < 10000L ? (count += helper.write(buf, String.format("%.2f", (double)durationInMicro / 1000.0))) : (count += helper.write(buf, Long.toString(durationInMillis))));
                count += helper.write(buf, "ms ");
            }
            count += helper.writeRaw(buf, String.valueOf(data));
            count += helper.td2(buf);
        } else {
            count += helper.td(buf, "");
            count += helper.td(buf, "");
        }
        count += helper.tr2(buf);
        return count += helper.crlf(buf);
    }

    protected int encodeLogViewLink(MessageTree tree, Message message, ByteBuf buf, int level, LineCounter counter) {
        BufferHelper helper = this.m_bufferHelper;
        Map<String, String> links = this.parseLinks(message.getData().toString());
        int count = 0;
        for (Map.Entry<String, String> e : links.entrySet()) {
            String link = e.getKey();
            String title = e.getValue();
            if (title.length() == 0) {
                title = "show";
            }
            if (counter != null) {
                counter.inc();
                count += helper.tr1(buf, "link");
            } else {
                count += helper.tr1(buf, null);
            }
            count += helper.td1(buf);
            count += helper.nbsp(buf, level * 2);
            count += helper.write(buf, String.format("<a href=\"%s%s\" onclick=\"return show(this,'%s');\">[:: %s ::]</a>", this.m_logViewPrefix, link, link, title));
            count += helper.td2(buf);
            count += helper.td(buf, "<div id=\"" + link + "\"></div>", "colspan=\"4\"");
            count += helper.tr2(buf);
            count += helper.crlf(buf);
        }
        return count;
    }

    protected int encodeMessage(MessageTree tree, Message message, ByteBuf buf, int level, LineCounter counter) {
        if (message instanceof Transaction) {
            Transaction transaction = (Transaction)message;
            List children = transaction.getChildren();
            if (children.isEmpty()) {
                if (transaction.getDurationInMillis() < 0L) {
                    return this.encodeLine(tree, (Message)transaction, buf, 't', Policy.WITHOUT_STATUS, level, counter);
                }
                return this.encodeLine(tree, (Message)transaction, buf, 'A', Policy.WITH_DURATION, level, counter);
            }
            int count = 0;
            count += this.encodeLine(tree, (Message)transaction, buf, 't', Policy.WITHOUT_STATUS, level, counter);
            for (Message child : children) {
                count += this.encodeMessage(tree, child, buf, level + 1, counter);
            }
            return count += this.encodeLine(tree, (Message)transaction, buf, 'T', Policy.WITH_DURATION, level, counter);
        }
        if (message instanceof Event) {
            String type = message.getType();
            if ("RemoteCall".equals(type)) {
                return this.encodeLogViewLink(tree, message, buf, level, counter);
            }
            if ("RemoteLink".equals(type)) {
                return this.encodeRemoteLink(tree, message, buf, level, counter);
            }
            return this.encodeLine(tree, message, buf, 'E', Policy.DEFAULT, level, counter);
        }
        if (message instanceof Trace) {
            return this.encodeLine(tree, message, buf, 'L', Policy.DEFAULT, level, counter);
        }
        if (message instanceof Metric) {
            return this.encodeLine(tree, message, buf, 'M', Policy.DEFAULT, level, counter);
        }
        if (message instanceof Heartbeat) {
            return this.encodeLine(tree, message, buf, 'H', Policy.DEFAULT, level, counter);
        }
        throw new RuntimeException(String.format("Unsupported message type: %s.", message.getClass()));
    }

    protected int encodeRemoteLink(MessageTree tree, Message message, ByteBuf buf, int level, LineCounter counter) {
        BufferHelper helper = this.m_bufferHelper;
        int count = 0;
        if (counter != null) {
            counter.inc();
            count += helper.tr1(buf, "link");
        } else {
            count += helper.tr1(buf, null);
        }
        String link = message.getData().toString();
        String name = message.getName();
        count += helper.td1(buf);
        count += helper.nbsp(buf, level * 2);
        count += helper.write(buf, String.format("<a href=\"%s%s\" onclick=\"return show(this,'%s');\">[:: %s ::]</a>", this.m_logViewPrefix, link, link, name));
        count += helper.td2(buf);
        count += helper.td(buf, "<div id=\"" + link + "\"></div>", "colspan=\"4\"");
        count += helper.tr2(buf);
        return count += helper.crlf(buf);
    }

    public void initialize() throws InitializationException {
        this.m_bufferHelper = new BufferHelper(this.m_writer);
    }

    protected Map<String, String> parseLinks(String str) {
        LinkedHashMap<String, String> links = new LinkedHashMap<String, String>();
        int len = str.length();
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean inName = true;
        block4: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    links.put(name.toString(), value.toString());
                    name.setLength(0);
                    value.setLength(0);
                    inName = true;
                    continue block4;
                }
                case '=': {
                    if (inName) {
                        inName = false;
                        continue block4;
                    }
                }
                default: {
                    if (inName) {
                        name.append(ch);
                        continue block4;
                    }
                    value.append(ch);
                }
            }
        }
        if (name.length() > 0) {
            links.put(name.toString(), value.toString());
        }
        return links;
    }

    public void setBufferWriter(BufferWriter writer) {
        this.m_writer = writer;
        this.m_bufferHelper = new BufferHelper(this.m_writer);
    }

    public void setLogViewPrefix(String logViewPrefix) {
        this.m_logViewPrefix = logViewPrefix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Policy {
        DEFAULT,
        WITHOUT_STATUS,
        WITH_DURATION;


        public static Policy getByMessageIdentifier(byte identifier) {
            switch (identifier) {
                case 116: {
                    return WITHOUT_STATUS;
                }
                case 65: 
                case 84: {
                    return WITH_DURATION;
                }
                case 69: 
                case 72: {
                    return DEFAULT;
                }
            }
            return DEFAULT;
        }
    }

    protected static class LineCounter {
        private int m_count;

        protected LineCounter() {
        }

        public int getCount() {
            return this.m_count;
        }

        public void inc() {
            ++this.m_count;
        }
    }

    protected static class DateHelper {
        private static final String DATE_PATTERN = "HH:mm:ss.SSS";
        private BlockingQueue<SimpleDateFormat> m_queue = new ArrayBlockingQueue<SimpleDateFormat>(20);

        protected DateHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String format(long timestamp) {
            SimpleDateFormat format = (SimpleDateFormat)this.m_queue.poll();
            if (format == null) {
                format = new SimpleDateFormat(DATE_PATTERN);
                format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            }
            try {
                String string = format.format(new Date(timestamp));
                return string;
            }
            finally {
                if (this.m_queue.remainingCapacity() > 0) {
                    this.m_queue.offer(format);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long parse(String str) {
            SimpleDateFormat format = (SimpleDateFormat)this.m_queue.poll();
            if (format == null) {
                format = new SimpleDateFormat(DATE_PATTERN);
                format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            }
            try {
                long l = format.parse(str).getTime();
                return l;
            }
            catch (ParseException e) {
                long l = -1L;
                return l;
            }
            finally {
                if (this.m_queue.remainingCapacity() > 0) {
                    this.m_queue.offer(format);
                }
            }
        }
    }

    protected static class BufferHelper {
        private static byte[] TABLE1 = "<table class=\"logview\">".getBytes();
        private static byte[] TABLE2 = "</table>".getBytes();
        private static byte[] TR1 = "<tr>".getBytes();
        private static byte[] TR2 = "</tr>".getBytes();
        private static byte[] TD1 = "<td>".getBytes();
        private static byte[] TD2 = "</td>".getBytes();
        private static byte[] NBSP = "&nbsp;".getBytes();
        private static byte[] CRLF = "\r\n".getBytes();
        private BufferWriter m_writer;

        public BufferHelper(BufferWriter writer) {
            this.m_writer = writer;
        }

        public int crlf(ByteBuf buf) {
            buf.writeBytes(CRLF);
            return CRLF.length;
        }

        public int nbsp(ByteBuf buf, int count) {
            for (int i = 0; i < count; ++i) {
                buf.writeBytes(NBSP);
            }
            return count * NBSP.length;
        }

        public int table1(ByteBuf buf) {
            buf.writeBytes(TABLE1);
            return TABLE1.length;
        }

        public int table2(ByteBuf buf) {
            buf.writeBytes(TABLE2);
            return TABLE2.length;
        }

        public int td(ByteBuf buf, String str) {
            return this.td(buf, str, null);
        }

        public int td(ByteBuf buf, String str, String attributes) {
            if (str == null) {
                str = "null";
            }
            byte[] data = str.getBytes();
            int count = 0;
            if (attributes == null) {
                buf.writeBytes(TD1);
                count += TD1.length;
            } else {
                String tag = "<td " + attributes + ">";
                byte[] bytes = tag.getBytes();
                buf.writeBytes(bytes);
                count += bytes.length;
            }
            buf.writeBytes(data);
            count += data.length;
            buf.writeBytes(TD2);
            return count += TD2.length;
        }

        public int td1(ByteBuf buf) {
            buf.writeBytes(TD1);
            return TD1.length;
        }

        public int td1(ByteBuf buf, String attributes) {
            if (attributes == null) {
                buf.writeBytes(TD1);
                return TD1.length;
            }
            String tag = "<td " + attributes + ">";
            byte[] bytes = tag.getBytes();
            buf.writeBytes(bytes);
            return bytes.length;
        }

        public int td2(ByteBuf buf) {
            buf.writeBytes(TD2);
            return TD2.length;
        }

        public int tr1(ByteBuf buf, String styleClass) {
            if (styleClass == null) {
                buf.writeBytes(TR1);
                return TR1.length;
            }
            String tag = "<tr class=\"" + styleClass + "\">";
            byte[] bytes = tag.getBytes();
            buf.writeBytes(bytes);
            return bytes.length;
        }

        public int tr2(ByteBuf buf) {
            buf.writeBytes(TR2);
            return TR2.length;
        }

        public int write(ByteBuf buf, byte b) {
            buf.writeByte((int)b);
            return 1;
        }

        public int write(ByteBuf buf, String str) {
            if (str == null) {
                str = "null";
            }
            byte[] data = str.getBytes();
            buf.writeBytes(data);
            return data.length;
        }

        public int writeRaw(ByteBuf buf, String str) {
            byte[] data;
            if (str == null) {
                str = "null";
            }
            try {
                data = str.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                data = str.getBytes();
            }
            return this.m_writer.writeTo(buf, data);
        }
    }
}

