/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.mvc;

import com.dianping.cat.Cat;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.mvc.HistoryNav;
import com.dianping.cat.mvc.UrlNav;
import com.dianping.cat.service.HostinfoService;
import com.dianping.cat.service.ProjectService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.ContainerLoader;
import org.unidal.web.mvc.Action;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.ViewModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportModel<A extends Action, P extends Page, M extends ActionContext<?>>
extends ViewModel<P, A, M> {
    private Date m_creatTime;
    private String m_customDate;
    private long m_date;
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat("yyyyMMddHH");
    private SimpleDateFormat m_dayFormat = new SimpleDateFormat("yyyyMMdd");
    private String m_displayDomain;
    private Throwable m_exception;
    private String m_ipAddress;
    private String m_reportType;
    private ProjectService m_projectService;
    private HostinfoService m_hostinfoService;

    public AbstractReportModel(M ctx) {
        super(ctx);
        try {
            this.m_projectService = (ProjectService)ContainerLoader.getDefaultContainer().lookup(ProjectService.class);
            this.m_hostinfoService = (HostinfoService)ContainerLoader.getDefaultContainer().lookup(HostinfoService.class);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public String getBaseUri() {
        return this.buildPageUri(this.getPage().getPath(), null);
    }

    public Date getCreatTime() {
        return this.m_creatTime;
    }

    public HistoryNav getCurrentNav() {
        return HistoryNav.getByName(this.m_reportType);
    }

    public Date getCurrentTime() {
        return new Date();
    }

    public String getCustomDate() {
        return this.m_customDate;
    }

    public String getDate() {
        if (this.m_reportType != null && this.m_reportType.length() > 0) {
            return this.m_dayFormat.format(new Date(this.m_date));
        }
        return this.m_dateFormat.format(new Date(this.m_date));
    }

    public String getDisplayDomain() {
        return this.m_displayDomain;
    }

    public String getDisplayHour() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.m_date);
        int hour = cal.get(11);
        if (hour < 10) {
            return "0" + Integer.toString(hour);
        }
        return Integer.toString(hour);
    }

    public abstract String getDomain();

    public Map<String, ProjectService.Department> getDomainGroups() {
        return this.m_projectService.findDepartments(this.getDomains());
    }

    public abstract Collection<String> getDomains();

    public Throwable getException() {
        return this.m_exception;
    }

    public HistoryNav[] getHistoryNavs() {
        return HistoryNav.values();
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public List<String> getIps() {
        return new ArrayList<String>();
    }

    public Map<String, String> getIpToHostname() {
        List<String> ips = this.getIps();
        HashMap<String, String> ipToHostname = new HashMap<String, String>();
        for (String ip : ips) {
            String hostname = this.m_hostinfoService.queryHostnameByIp(ip);
            if (hostname == null || hostname.equalsIgnoreCase("null")) continue;
            ipToHostname.put(ip, hostname);
        }
        return ipToHostname;
    }

    public String getIpToHostnameStr() {
        return new JsonBuilder().toJson(this.getIpToHostname());
    }

    public long getLongDate() {
        return this.m_date;
    }

    public UrlNav[] getNavs() {
        return UrlNav.values();
    }

    public String getReportType() {
        return this.m_reportType;
    }

    public void setCreatTime(Date creatTime) {
        this.m_creatTime = creatTime;
    }

    public void setCustomDate(Date start, Date end) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        StringBuilder sb = new StringBuilder();
        sb.append("&startDate=").append(sdf.format(start)).append("&endDate=").append(sdf.format(end));
        this.m_customDate = sb.toString();
    }

    public void setDisplayDomain(String displayDomain) {
        this.m_displayDomain = displayDomain;
    }

    public void setException(Throwable exception) {
        this.m_exception = exception;
    }

    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    public void setDate(long date) {
        this.m_date = date;
    }

    public void setReportType(String reportType) {
        this.m_reportType = reportType;
    }
}

