/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.mvc;

import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.service.ModelPeriod;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.Action;
import org.unidal.web.mvc.ActionPayload;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.payload.annotation.FieldMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportPayload<A extends Action, P extends Page>
implements ActionPayload<P, A> {
    @FieldMeta(value="endDate")
    protected String m_customEnd;
    @FieldMeta(value="startDate")
    protected String m_customStart;
    @FieldMeta(value="date")
    protected long m_date;
    @FieldMeta(value="domain")
    private String m_domain = "cat";
    @FieldMeta(value="ip")
    private String m_ipAddress = "All";
    protected P m_page;
    @FieldMeta(value="reportType")
    private String m_reportType = "day";
    @FieldMeta(value="step")
    protected int m_step;
    private SimpleDateFormat m_hourlyFormat = new SimpleDateFormat("yyyyMMddHH");
    private SimpleDateFormat m_dayFormat = new SimpleDateFormat("yyyyMMdd");
    protected P m_defaultPage;

    public AbstractReportPayload(P defaultPage) {
        this.m_defaultPage = defaultPage;
    }

    private void checkFutureDate() {
        if ("day".equals(this.m_reportType)) {
            Calendar today = Calendar.getInstance();
            long current = this.getCurrentDate();
            today.setTimeInMillis(current);
            today.set(11, 0);
            if (this.m_date == today.getTimeInMillis()) {
                this.m_date -= 86400000L;
            }
        }
    }

    public void computeHistoryDate() {
        if (this.m_date <= 0L) {
            this.m_date = TimeHelper.getCurrentDay(-1).getTime();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.m_date);
        cal.set(11, 0);
        this.m_date = cal.getTimeInMillis();
        if ("month".equals(this.m_reportType)) {
            cal.set(5, 1);
            this.m_date = cal.getTimeInMillis();
        } else if ("week".equals(this.m_reportType)) {
            int weekOfDay = cal.get(7) % 7;
            this.m_date -= 3600000L * (long)(weekOfDay % 7) * 24L;
            if (this.m_date > System.currentTimeMillis()) {
                this.m_date -= 604800000L;
            }
            cal.setTimeInMillis(this.m_date);
        }
        if (this.m_step < 0) {
            if ("month".equals(this.m_reportType)) {
                cal.add(2, this.m_step);
                this.m_date = cal.getTimeInMillis();
            } else if ("week".equals(this.m_reportType)) {
                this.m_date += 604800000L * (long)this.m_step;
            } else if ("day".equals(this.m_reportType)) {
                this.m_date += 86400000L * (long)this.m_step;
            }
        } else {
            long temp = 0L;
            if ("month".equals(this.m_reportType)) {
                cal.add(2, this.m_step);
                temp = cal.getTimeInMillis();
            } else if ("week".equals(this.m_reportType)) {
                temp = this.m_date + 604800000L * (long)this.m_step;
            } else if ("day".equals(this.m_reportType)) {
                temp = this.m_date + 86400000L * (long)this.m_step;
            }
            if (temp <= this.getCurrentStartDay()) {
                this.m_date = temp;
            }
        }
        this.checkFutureDate();
    }

    public long getCurrentDate() {
        long timestamp = System.currentTimeMillis();
        return timestamp - timestamp % 3600000L;
    }

    public long getCurrentStartDay() {
        long timestamp = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(timestamp));
        cal.set(11, 0);
        return cal.getTimeInMillis();
    }

    public long getDate() {
        long current = this.getCurrentDate();
        long extra = (long)this.m_step * 3600000L;
        if (this.m_date <= 0L) {
            return current + extra;
        }
        long result = this.m_date + extra;
        if (result > current) {
            return current;
        }
        return result;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public Date getHistoryDisplayEndDate() {
        Date date = this.getHistoryEndDate();
        return new Date(date.getTime() - 1000L);
    }

    public Date getHistoryEndDate() {
        if (this.m_customEnd != null) {
            try {
                if (this.m_customEnd.length() == 8) {
                    return this.m_dayFormat.parse(this.m_customEnd);
                }
                if (this.m_customEnd.length() == 10) {
                    return this.m_hourlyFormat.parse(this.m_customEnd);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        long temp = 0L;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.m_date);
        if ("month".equals(this.m_reportType)) {
            int maxDay = cal.getActualMaximum(5);
            temp = this.m_date + (long)maxDay * 86400000L;
        } else {
            temp = "week".equals(this.m_reportType) ? this.m_date + 604800000L : this.m_date + 86400000L;
        }
        cal.setTimeInMillis(temp);
        return cal.getTime();
    }

    public Date getHistoryStartDate() {
        if (this.m_customStart != null) {
            try {
                if (this.m_customStart.length() == 8) {
                    return this.m_dayFormat.parse(this.m_customStart);
                }
                if (this.m_customStart.length() == 10) {
                    return this.m_hourlyFormat.parse(this.m_customStart);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Date(this.m_date);
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public P getPage() {
        return this.m_page;
    }

    public ModelPeriod getPeriod() {
        return ModelPeriod.getByTime(this.getDate());
    }

    public long getRealDate() {
        return this.m_date;
    }

    public String getReportType() {
        return this.m_reportType;
    }

    public int getStep() {
        return this.m_step;
    }

    public void setCustomEnd(String customEnd) {
        this.m_customEnd = customEnd;
    }

    public void setCustomStart(String customStart) {
        this.m_customStart = customStart;
    }

    public void setDate(String date) {
        if (date == null || date.length() == 0) {
            this.m_date = this.getCurrentDate();
        } else {
            try {
                Date temp = null;
                temp = date.length() == 10 ? this.m_hourlyFormat.parse(date) : this.m_dayFormat.parse(date);
                this.m_date = temp.getTime();
            }
            catch (Exception e) {
                this.m_date = this.getCurrentDate();
            }
        }
    }

    public void setDomain(String domain) {
        if (StringUtils.isNotEmpty((String)domain)) {
            this.m_domain = domain;
        }
    }

    public void setIpAddress(String ipAddress) {
        if (StringUtils.isNotEmpty((String)ipAddress)) {
            this.m_ipAddress = ipAddress;
        }
    }

    public void setPage(P page) {
        this.m_page = page;
    }

    public void setReportType(String reportType) {
        if (StringUtils.isNotEmpty((String)reportType)) {
            this.m_reportType = reportType;
        }
    }

    public void setStep(int nav) {
        this.m_step = nav;
    }
}

