/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.service;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.service.BaseRemoteModelService;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.report.service.ModelServiceWithCalSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.unidal.helper.Splitters;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCompositeModelService<T>
extends ModelServiceWithCalSupport
implements ModelService<T>,
Initializable {
    private static ExecutorService s_threadPool = Threads.forPool().getFixedThreadPool("Cat-ModelService", 30);
    private List<ModelService<T>> m_allServices = new ArrayList<ModelService<T>>();
    @Inject
    protected ServerConfigManager m_configManager;
    private String m_name;
    @Inject
    private List<ModelService<T>> m_services;

    public BaseCompositeModelService(String name) {
        this.m_name = name;
    }

    protected abstract BaseRemoteModelService<T> createRemoteService();

    @Override
    public String getName() {
        return this.m_name;
    }

    public void initialize() throws InitializationException {
        this.m_allServices.addAll(this.m_services);
        String remoteServers = this.m_configManager.getConsoleRemoteServers();
        List endpoints = Splitters.by((char)',').noEmptyItem().trim().split(remoteServers);
        for (String endpoint : endpoints) {
            int pos = endpoint.indexOf(58);
            String host = pos > 0 ? endpoint.substring(0, pos) : endpoint;
            int port = pos > 0 ? Integer.parseInt(endpoint.substring(pos + 1)) : 2281;
            BaseRemoteModelService<T> remote = this.createRemoteService();
            remote.setHost(host);
            remote.setPort(port);
            this.m_allServices.add(remote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelResponse<T> invoke(final ModelRequest request) {
        int requireSize = 0;
        final List<ModelResponse<T>> responses = Collections.synchronizedList(new ArrayList());
        final Semaphore semaphore = new Semaphore(0);
        final Transaction t = Cat.getProducer().newTransaction("ModelService", this.getClass().getSimpleName());
        int count = 0;
        t.setStatus("0");
        t.addData("request", (Object)request);
        t.addData("thread", (Object)Thread.currentThread());
        for (final ModelService<T> service : this.m_allServices) {
            if (!service.isEligable(request)) continue;
            if (service instanceof ModelServiceWithCalSupport) {
                ((ModelServiceWithCalSupport)((Object)service)).setParentTransaction(t);
            }
            ++requireSize;
            s_threadPool.submit(new Runnable(){

                public void run() {
                    try {
                        ModelResponse response = service.invoke(request);
                        if (response.getException() != null) {
                            BaseCompositeModelService.this.logError(response.getException());
                        }
                        if (response != null && response.getModel() != null) {
                            responses.add(response);
                        }
                    }
                    catch (Exception e) {
                        BaseCompositeModelService.this.logError(e);
                        t.setStatus((Throwable)e);
                    }
                    finally {
                        semaphore.release();
                    }
                }
            });
            ++count;
        }
        try {
            semaphore.tryAcquire(count, 10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
        String requireAll = request.getProperty("requireAll");
        if (requireAll != null && responses.size() != requireSize) {
            String data = "require:" + requireSize + " actual:" + responses.size();
            Cat.logEvent((String)("FetchReportError:" + this.getClass().getSimpleName()), (String)request.getDomain(), (String)"0", (String)data);
            return null;
        }
        ModelResponse<T> aggregated = new ModelResponse<T>();
        T report = this.merge(request, responses);
        aggregated.setModel(report);
        return aggregated;
    }

    @Override
    public boolean isEligable(ModelRequest request) {
        for (ModelService<T> service : this.m_allServices) {
            if (!service.isEligable(request)) continue;
            return true;
        }
        return false;
    }

    protected abstract T merge(ModelRequest var1, List<ModelResponse<T>> var2);

    public void setSerivces(ModelService<T> ... services) {
        for (ModelService<T> service : services) {
            this.m_allServices.add(service);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("name=").append(this.m_name);
        sb.append(']');
        return sb.toString();
    }
}

