/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.service;

import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.report.service.ModelServiceWithCalSupport;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHistoricalModelService<T>
extends ModelServiceWithCalSupport
implements ModelService<T>,
Initializable {
    @Inject
    private ServerConfigManager m_manager;
    private boolean m_localMode = true;
    private String m_name;

    public BaseHistoricalModelService(String name) {
        this.m_name = name;
    }

    protected abstract T buildModel(ModelRequest var1) throws Exception;

    @Override
    public String getName() {
        return this.m_name;
    }

    public void initialize() throws InitializationException {
        this.m_localMode = this.m_manager.isLocalMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelResponse<T> invoke(ModelRequest request) {
        ModelResponse<T> response = new ModelResponse<T>();
        Transaction t = this.newTransaction("ModelService", this.getClass().getSimpleName());
        t.addData("thread", (Object)Thread.currentThread());
        try {
            T model = this.buildModel(request);
            response.setModel(model);
            t.setStatus("0");
        }
        catch (Exception e) {
            this.logError(e);
            t.setStatus((Throwable)e);
            response.setException(e);
        }
        finally {
            t.complete();
        }
        return response;
    }

    @Override
    public boolean isEligable(ModelRequest request) {
        return request.getPeriod().isHistorical();
    }

    protected boolean isLocalMode() {
        return this.m_localMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("name=").append(this.m_name).append(']');
        return sb.toString();
    }
}

