/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.service;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import com.dianping.cat.report.service.ModelServiceWithCalSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.unidal.helper.Files;
import org.unidal.helper.Urls;
import org.unidal.lookup.annotation.Inject;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRemoteModelService<T>
extends ModelServiceWithCalSupport
implements ModelService<T> {
    private String m_host;
    private String m_name;
    private int m_port = 2281;
    @Inject
    private String m_serviceUri = "/cat/r/model";

    public BaseRemoteModelService(String name) {
        this.m_name = name;
    }

    protected abstract T buildModel(String var1) throws SAXException, IOException;

    public URL buildUrl(ModelRequest request) throws MalformedURLException {
        StringBuilder sb = new StringBuilder(64);
        for (Map.Entry<String, String> e : request.getProperties().entrySet()) {
            if (e.getValue() == null) continue;
            try {
                sb.append('&');
                sb.append(e.getKey()).append('=').append(URLEncoder.encode(e.getValue(), "utf-8"));
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        String url = String.format("http://%s:%s%s/%s/%s/%s?op=xml%s", new Object[]{this.m_host, this.m_port, this.m_serviceUri, this.m_name, request.getDomain(), request.getPeriod(), sb.toString()});
        return new URL(url);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelResponse<T> invoke(ModelRequest request) {
        Transaction t = this.newTransaction("ModelService", this.getClass().getSimpleName());
        try {
            URL url = this.buildUrl(request);
            t.addData(url.toString());
            InputStream in = Urls.forIO().connectTimeout(1000).readTimeout(10000).openStream(url.toExternalForm());
            GZIPInputStream gzip = new GZIPInputStream(in);
            String xml = Files.forIO().readFrom((InputStream)gzip, "utf-8");
            int len = xml == null ? 0 : xml.length();
            t.addData("length", (Object)len);
            if (len > 0) {
                ModelResponse<T> response = new ModelResponse<T>();
                T report = this.buildModel(xml);
                response.setModel(report);
                t.setStatus("0");
                ModelResponse<T> modelResponse = response;
                return modelResponse;
            }
            t.setStatus("NoReport");
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
        return null;
    }

    @Override
    public boolean isEligable(ModelRequest request) {
        ModelPeriod period = request.getPeriod();
        return !period.isHistorical();
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public void setServiceUri(String serviceUri) {
        this.m_serviceUri = serviceUri;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("name=").append(this.m_name);
        sb.append(']');
        return sb.toString();
    }
}

