/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.service;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.core.dal.Hostinfo;
import com.dianping.cat.core.dal.HostinfoDao;
import com.dianping.cat.core.dal.HostinfoEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostinfoService
implements Initializable,
LogEnabled {
    @Inject
    private HostinfoDao m_hostinfoDao;
    @Inject
    private ServerConfigManager m_manager;
    private Map<String, String> m_ipDomains = new ConcurrentHashMap<String, String>();
    private Map<String, Hostinfo> m_hostinfos = new ConcurrentHashMap<String, Hostinfo>();
    public static final String UNKNOWN_PROJECT = "UnknownProject";
    protected Logger m_logger;

    public Hostinfo createLocal() {
        return this.m_hostinfoDao.createLocal();
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public List<Hostinfo> findAll() throws DalException {
        return new ArrayList<Hostinfo>(this.m_hostinfos.values());
    }

    public Hostinfo findByIp(String ip) {
        Hostinfo hostinfo = this.m_hostinfos.get(ip);
        if (hostinfo != null) {
            return hostinfo;
        }
        try {
            hostinfo = this.m_hostinfoDao.findByIp(ip, HostinfoEntity.READSET_FULL);
            if (hostinfo != null) {
                this.m_hostinfos.put(ip, hostinfo);
                return hostinfo;
            }
            return null;
        }
        catch (DalNotFoundException dalNotFoundException) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return null;
    }

    public void initialize() throws InitializationException {
        this.refresh();
    }

    private boolean insert(Hostinfo hostinfo) throws DalException {
        this.m_hostinfos.put(hostinfo.getIp(), hostinfo);
        int result = this.m_hostinfoDao.insert(hostinfo);
        return result == 1;
    }

    public boolean insert(String domain, String ip) {
        try {
            Hostinfo info = this.createLocal();
            info.setDomain(domain);
            info.setIp(ip);
            this.insert(info);
            this.m_hostinfos.put(ip, info);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public String queryDomainByIp(String ip) {
        String project = this.m_ipDomains.get(ip);
        if (project == null) {
            return UNKNOWN_PROJECT;
        }
        return project;
    }

    public String queryHostnameByIp(String ip) {
        try {
            if (this.validateIp(ip)) {
                Hostinfo info = this.m_hostinfos.get(ip);
                String hostname = null;
                if (info != null && StringUtils.isNotEmpty((String)(hostname = info.getHostname()))) {
                    return hostname;
                }
                info = this.findByIp(ip);
                if (info != null) {
                    this.m_hostinfos.put(ip, info);
                    hostname = info.getHostname();
                }
                return hostname;
            }
            return null;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    public List<String> queryIpsByDomain(String domain) {
        ArrayList<String> ips = new ArrayList<String>();
        if (domain == null) {
            return ips;
        }
        for (Hostinfo hostinfo : this.m_hostinfos.values()) {
            String ip;
            if (!domain.equals(hostinfo.getDomain()) || (ip = hostinfo.getIp()) == null || ip.length() <= 0) continue;
            ips.add(ip);
        }
        return ips;
    }

    protected void refresh() {
        try {
            List<Hostinfo> hostinfos = this.m_hostinfoDao.findAllIp(HostinfoEntity.READSET_FULL);
            ConcurrentHashMap<String, Hostinfo> tmpHostInfos = new ConcurrentHashMap<String, Hostinfo>();
            ConcurrentHashMap<String, String> tmpIpDomains = new ConcurrentHashMap<String, String>();
            for (Hostinfo hostinfo : hostinfos) {
                tmpHostInfos.put(hostinfo.getIp(), hostinfo);
                tmpIpDomains.put(hostinfo.getIp(), hostinfo.getDomain());
            }
            this.m_hostinfos = tmpHostInfos;
            this.m_ipDomains = tmpIpDomains;
        }
        catch (DalException e) {
            Cat.logError((String)"initialize HostService error", (Throwable)e);
        }
    }

    public boolean update(int id, String domain, String ip) {
        Hostinfo info = this.createLocal();
        info.setId(id);
        info.setDomain(domain);
        info.setIp(ip);
        info.setLastModifiedDate(new Date());
        this.updateHostinfo(info);
        this.m_hostinfos.put(ip, info);
        return true;
    }

    public boolean updateHostinfo(Hostinfo hostinfo) {
        this.m_hostinfos.put(hostinfo.getIp(), hostinfo);
        try {
            this.m_hostinfoDao.updateByPK(hostinfo, HostinfoEntity.UPDATESET_FULL);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    private boolean validateIp(String str) {
        Pattern pattern = Pattern.compile("^((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])$");
        return pattern.matcher(str).matches();
    }
}

