/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.service;

import com.dianping.cat.Cat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

public class IpService
implements Initializable {
    private int[] m_areaIds;
    private Map<Integer, Area> m_areas;
    private int[] m_corpIds;
    private Map<Integer, Corporation> m_corps;
    private long[] m_ends;
    private long[] m_starts;
    private int[] m_foreignAreaIds;
    private Map<Integer, Area> m_foreignAreas;
    private long[] m_foreignEnds;
    private long[] m_foreignStarts;
    private static final String OTHER = "\u5176\u4ed6";
    private String FOREIGN_OTHER = "\u56fd\u5916\u5176\u4ed6";
    private String FOREIGN = "\u56fd\u5916";

    private IpInfo buildDefaultIpInfo(String nation, String other) {
        IpInfo ipInfo = new IpInfo();
        ipInfo.setNation(nation);
        ipInfo.setProvince(other);
        ipInfo.setCity(other);
        ipInfo.setChannel(other);
        return ipInfo;
    }

    private IpInfo findChinaIp(long ip) {
        int low = 0;
        int high = this.m_starts.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (ip >= this.m_starts[mid] && ip <= this.m_ends[mid]) {
                IpInfo ipInfo = new IpInfo();
                Area area = this.m_areas.get(this.m_areaIds[mid]);
                if (area != null) {
                    ipInfo.setNation(area.getNation());
                    ipInfo.setProvince(area.getProvince());
                    ipInfo.setCity(area.getCity());
                } else {
                    ipInfo.setNation(OTHER);
                    ipInfo.setProvince(OTHER);
                    ipInfo.setCity(OTHER);
                }
                Corporation corp = this.m_corps.get(this.m_corpIds[mid]);
                if (corp != null) {
                    ipInfo.setChannel(corp.getName());
                } else {
                    ipInfo.setChannel(OTHER);
                }
                return ipInfo;
            }
            if (ip < this.m_starts[mid]) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return null;
    }

    private IpInfo findForeignIp(long ip) {
        int low = 0;
        int high = this.m_foreignStarts.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (ip >= this.m_foreignStarts[mid] && ip <= this.m_foreignEnds[mid]) {
                IpInfo ipInfo = new IpInfo();
                Area area = this.m_foreignAreas.get(this.m_foreignAreaIds[mid]);
                if (area != null) {
                    ipInfo.setNation(area.getNation());
                    ipInfo.setProvince(area.getProvince());
                    ipInfo.setCity(area.getCity());
                } else {
                    ipInfo.setNation(this.FOREIGN);
                    ipInfo.setProvince(this.FOREIGN_OTHER);
                    ipInfo.setCity(this.FOREIGN_OTHER);
                }
                ipInfo.setChannel(this.FOREIGN_OTHER);
                return ipInfo;
            }
            if (ip < this.m_foreignStarts[mid]) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return this.buildDefaultIpInfo(this.FOREIGN, this.FOREIGN_OTHER);
    }

    private IpInfo findIpInfo(long ip) {
        IpInfo ipInfo = this.findChinaIp(ip);
        if (ipInfo == null) {
            ipInfo = this.findForeignIp(ip);
        }
        return ipInfo;
    }

    public IpInfo findIpInfoByString(String ip) {
        try {
            String[] segments = ip.split("\\.");
            if (segments.length != 4) {
                return null;
            }
            long ip_num = Long.parseLong(segments[0]) << 24;
            ip_num += (long)(Integer.parseInt(segments[1]) << 16);
            ip_num += (long)(Integer.parseInt(segments[2]) << 8);
            return this.findIpInfo(ip_num += (long)Integer.parseInt(segments[3]));
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initAreaMap(InputStream areaFile) {
        try {
            String line;
            BufferedReader areaReader = new BufferedReader(new InputStreamReader(areaFile));
            this.m_areas = new LinkedHashMap<Integer, Area>();
            while ((line = areaReader.readLine()) != null) {
                String[] strs = line.split(":");
                int id = Integer.parseInt(strs[1]);
                String[] areaStr = strs[0].split("\\|");
                Area area = new Area();
                area.setAreaId(id);
                area.setNation(areaStr[0]);
                area.setProvince(areaStr[1]);
                area.setCity(areaStr[2]);
                this.m_areas.put(id, area);
            }
            areaReader.close();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    private void initCorpMap(InputStream corpFile) {
        try {
            String line;
            BufferedReader corpReader = new BufferedReader(new InputStreamReader(corpFile));
            this.m_corps = new LinkedHashMap<Integer, Corporation>();
            while ((line = corpReader.readLine()) != null) {
                String[] strs = line.split(":");
                Corporation corp = new Corporation();
                int id = Integer.parseInt(strs[1]);
                corp.setCorporationId(id);
                corp.setName(strs[0]);
                this.m_corps.put(id, corp);
            }
            corpReader.close();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    private void initForeignAreaMap(InputStream areaFile) {
        try {
            String line;
            BufferedReader areaReader = new BufferedReader(new InputStreamReader(areaFile));
            this.m_foreignAreas = new LinkedHashMap<Integer, Area>();
            while ((line = areaReader.readLine()) != null) {
                String[] strs = line.split(":");
                String[] ids = strs[1].split(",");
                Area area = new Area();
                area.setNation("\u56fd\u5916");
                area.setProvince(strs[0]);
                area.setCity(strs[0]);
                for (String id : ids) {
                    this.m_foreignAreas.put(Integer.valueOf(id), area);
                }
            }
            areaReader.close();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initForeignIpTable(InputStream ipFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ipFile));
            int size = Integer.parseInt(reader.readLine());
            this.m_foreignStarts = new long[size];
            this.m_foreignEnds = new long[size];
            this.m_foreignAreaIds = new int[size];
            for (int i = 0; i < size; ++i) {
                String line = reader.readLine();
                String[] strs = line.split(":");
                this.m_foreignStarts[i] = Long.parseLong(strs[0]);
                this.m_foreignEnds[i] = Long.parseLong(strs[1]);
                this.m_foreignAreaIds[i] = Integer.parseInt(strs[2]);
            }
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    public void initialize() throws InitializationException {
        InputStream areaFile = IpService.class.getClassLoader().getResourceAsStream("config/area_china");
        InputStream corpFile = IpService.class.getClassLoader().getResourceAsStream("config/corp_china");
        InputStream ipFile = IpService.class.getClassLoader().getResourceAsStream("config/iptable_china");
        this.initAreaMap(areaFile);
        this.initCorpMap(corpFile);
        this.initIpTable(ipFile);
        InputStream foreignAreaFile = IpService.class.getClassLoader().getResourceAsStream("config/area_foreign");
        InputStream foreignIpFile = IpService.class.getClassLoader().getResourceAsStream("config/iptable_foreign");
        this.initForeignAreaMap(foreignAreaFile);
        this.initForeignIpTable(foreignIpFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initIpTable(InputStream ipFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ipFile));
            int size = Integer.parseInt(reader.readLine());
            this.m_starts = new long[size];
            this.m_ends = new long[size];
            this.m_areaIds = new int[size];
            this.m_corpIds = new int[size];
            for (int i = 0; i < size; ++i) {
                String line = reader.readLine();
                String[] strs = line.split(":");
                this.m_starts[i] = Long.parseLong(strs[0]);
                this.m_ends[i] = Long.parseLong(strs[1]);
                this.m_areaIds[i] = Integer.parseInt(strs[2]);
                this.m_corpIds[i] = Integer.parseInt(strs[3]);
            }
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    public static class IpInfo {
        private String m_channel;
        private String m_city;
        private String m_nation;
        private String m_province;

        public String getChannel() {
            return this.m_channel;
        }

        public String getCity() {
            return this.m_city;
        }

        public String getNation() {
            return this.m_nation;
        }

        public String getProvince() {
            return this.m_province;
        }

        public void setChannel(String name) {
            this.m_channel = name;
        }

        public void setCity(String city) {
            this.m_city = city;
        }

        public void setNation(String nation) {
            this.m_nation = nation;
        }

        public void setProvince(String province) {
            this.m_province = province;
        }
    }

    public static class Corporation {
        private Integer m_corporationId;
        private String m_name;

        public Integer getCorporationId() {
            return this.m_corporationId;
        }

        public String getName() {
            return this.m_name;
        }

        public void setCorporationId(Integer corporationId) {
            this.m_corporationId = corporationId;
        }

        public void setName(String name) {
            this.m_name = name;
        }
    }

    public static class Area {
        private Integer m_areaId;
        private String m_city;
        private String m_nation;
        private String m_province;

        public Integer getAreaId() {
            return this.m_areaId;
        }

        public String getCity() {
            return this.m_city;
        }

        public String getNation() {
            return this.m_nation;
        }

        public String getProvince() {
            return this.m_province;
        }

        public void setAreaId(Integer areaId) {
            this.m_areaId = areaId;
        }

        public void setCity(String city) {
            this.m_city = city;
        }

        public void setNation(String nation) {
            this.m_nation = nation;
        }

        public void setProvince(String province) {
            this.m_province = province;
        }
    }
}

