/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.statistic;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class ServerStatistic {
    private Map<Long, Statistic> m_statistics = new ConcurrentHashMap<Long, Statistic>(100);

    public synchronized Statistic findOrCreate(Long time) {
        Statistic state = this.m_statistics.get(time);
        if (state == null) {
            state = new Statistic();
            this.m_statistics.put(time, state);
        }
        return state;
    }

    public void remove(long time) {
        this.m_statistics.remove(time);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Statistic {
        private long m_messageTotal;
        private long m_messageTotalLoss;
        private long m_messageSize;
        private long m_messageDump;
        private long m_messageDumpLoss;
        private ConcurrentMap<String, AtomicLong> m_messageTotals = new ConcurrentHashMap<String, AtomicLong>(256);
        private ConcurrentMap<String, AtomicLong> m_messageTotalLosses = new ConcurrentHashMap<String, AtomicLong>(256);
        private ConcurrentMap<String, AtomicLong> m_messageSizes = new ConcurrentHashMap<String, AtomicLong>(256);
        private double m_processDelaySum;
        private int m_processDelayCount;
        private long m_blockTotal;
        private long m_blockLoss;
        private long m_blockTime;
        private long m_pigeonTimeError;
        private long m_networkTimeError;

        public void addBlockLoss(long blockLoss) {
            this.m_blockLoss += blockLoss;
        }

        public void addBlockTime(long blockTime) {
            this.m_blockTime += blockTime;
        }

        public void addBlockTotal(long block) {
            this.m_blockTotal += block;
        }

        public void addMessageDump(long messageDump) {
            this.m_messageDump += messageDump;
        }

        public void addMessageDumpLoss(long messageDumpLoss) {
            this.m_messageDumpLoss += messageDumpLoss;
        }

        public void addMessageSize(String domain, int size) {
            this.m_messageSize += (long)size;
            AtomicLong value = (AtomicLong)this.m_messageSizes.get(domain);
            if (value != null) {
                value.addAndGet(size);
            } else {
                this.m_messageSizes.put(domain, new AtomicLong(size));
            }
        }

        public void addMessageTotal(long messageTotal) {
            this.m_messageTotal += messageTotal;
        }

        public void addMessageTotal(String domain, long messageTotal) {
            AtomicLong value = (AtomicLong)this.m_messageTotals.get(domain);
            if (value != null) {
                value.addAndGet(messageTotal);
            } else {
                this.m_messageTotals.put(domain, new AtomicLong(messageTotal));
            }
        }

        public void addMessageTotalLoss(long messageTotalLoss) {
            this.m_messageTotalLoss += messageTotalLoss;
        }

        public void addMessageTotalLoss(String domain, long messageTotalLoss) {
            this.m_messageTotalLoss += messageTotalLoss;
            AtomicLong value = (AtomicLong)this.m_messageTotalLosses.get(domain);
            if (value != null) {
                value.addAndGet(messageTotalLoss);
            } else {
                this.m_messageTotalLosses.put(domain, new AtomicLong(messageTotalLoss));
            }
        }

        public void addNetworkTimeError(long networkTimeError) {
            this.m_networkTimeError += networkTimeError;
        }

        public void addPigeonTimeError(long pigeonTimeError) {
            this.m_pigeonTimeError += pigeonTimeError;
        }

        public void addProcessDelay(double processDelay) {
            this.m_processDelaySum += processDelay;
            ++this.m_processDelayCount;
        }

        public double getAvgProcessDelay() {
            if (this.m_processDelayCount > 0) {
                return this.m_processDelaySum / (double)this.m_processDelayCount;
            }
            return 0.0;
        }

        public long getBlockLoss() {
            return this.m_blockLoss;
        }

        public long getBlockTime() {
            return this.m_blockTime;
        }

        public long getBlockTotal() {
            return this.m_blockTotal;
        }

        public long getMessageDump() {
            return this.m_messageDump;
        }

        public long getMessageDumpLoss() {
            return this.m_messageDumpLoss;
        }

        public long getMessageSize() {
            return this.m_messageSize;
        }

        public Map<String, AtomicLong> getMessageSizes() {
            return this.m_messageSizes;
        }

        public long getMessageTotal() {
            return this.m_messageTotal;
        }

        public long getMessageTotalLoss() {
            return this.m_messageTotalLoss;
        }

        public Map<String, AtomicLong> getMessageTotalLosses() {
            return this.m_messageTotalLosses;
        }

        public Map<String, AtomicLong> getMessageTotals() {
            return this.m_messageTotals;
        }

        public long getNetworkTimeError() {
            return this.m_networkTimeError;
        }

        public long getPigeonTimeError() {
            return this.m_pigeonTimeError;
        }

        public int getProcessDelayCount() {
            return this.m_processDelayCount;
        }

        public double getProcessDelaySum() {
            return this.m_processDelaySum;
        }
    }
}

