/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.concurrent.internals;

import java.util.ArrayList;
import java.util.List;
import org.unidal.concurrent.Stage;
import org.unidal.concurrent.StageConfiguration;
import org.unidal.concurrent.StageStatus;
import org.unidal.concurrent.internals.DefaultStageStatus;
import org.unidal.concurrent.internals.DefaultThreadWorker;
import org.unidal.concurrent.internals.ThreadPool;
import org.unidal.concurrent.internals.ThreadWorker;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

@Named(type=ThreadPool.class, instantiationStrategy="per-lookup")
public class DefaultThreadPool
implements ThreadPool,
LogEnabled {
    private static final int WINDOW_SIZE = 1;
    private Stage<?> m_stage;
    private StageConfiguration m_config;
    private List<ThreadWorker> m_workers = new ArrayList<ThreadWorker>();
    private List<Integer> m_flags = new ArrayList<Integer>();
    private Logger m_logger;

    @Override
    public void adjust(StageStatus current, StageStatus last) {
        if (current instanceof DefaultStageStatus) {
            DefaultStageStatus status = (DefaultStageStatus)current;
            int flag = this.filter(status.checkThroughput(last));
            int threads = this.m_workers.size();
            if (flag > 0 && threads < Math.min(status.getActors(), this.m_config.getThreadMaxCount())) {
                this.createNewWorker();
            } else if (flag < 0 && threads > this.m_config.getThreadMinCount()) {
                this.removeLastWorker();
            }
        }
    }

    private void createNewWorker() {
        int index = this.m_workers.size();
        DefaultThreadWorker worker = new DefaultThreadWorker(this.m_stage, index);
        this.m_logger.info(String.format("Create worker[%s] of stage(%s)", index, this.m_stage.getId()));
        Threads.forGroup("Cat").start(worker);
        this.m_workers.add(worker);
    }

    @Override
    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private int filter(int flag) {
        if (this.m_flags.size() >= 1) {
            this.m_flags.remove(0);
        }
        this.m_flags.add(flag);
        int total = 0;
        for (Integer f : this.m_flags) {
            total += f.intValue();
        }
        if (total == 1) {
            return 1;
        }
        if (total == -1) {
            return -1;
        }
        return 0;
    }

    private void removeLastWorker() {
        int index = this.m_workers.size() - 1;
        ThreadWorker worker = this.m_workers.remove(index);
        this.m_logger.info(String.format("Remove worker[%s] of stage(%s)", index, this.m_stage.getId()));
        worker.shutdown();
    }

    @Override
    public void report(StageStatus status) {
        int len = this.m_workers.size();
        long[] counts = new long[len];
        int[] costs = new int[len];
        for (int i = 0; i < len; ++i) {
            ThreadWorker worker = this.m_workers.get(i);
            long count = worker.getAndResetCount();
            int cost = worker.getAndResetCostInMillis();
            counts[i] = count;
            costs[i] = cost;
        }
        if (status instanceof DefaultStageStatus) {
            ((DefaultStageStatus)status).setProcessed(costs, counts);
        }
    }

    @Override
    public void shutdown() {
        for (ThreadWorker worker : this.m_workers) {
            worker.shutdown();
        }
    }

    @Override
    public void start(Stage<?> stage, StageConfiguration config) {
        this.m_stage = stage;
        this.m_config = config;
        for (int i = 0; i < config.getThreadMinCount(); ++i) {
            this.createNewWorker();
        }
    }
}

