/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.initialization;

import java.util.LinkedHashSet;
import java.util.Set;
import org.unidal.initialization.AbstractModule;
import org.unidal.initialization.Module;
import org.unidal.initialization.ModuleContext;
import org.unidal.initialization.ModuleInitializer;
import org.unidal.initialization.ModuleManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.InjectAttribute;
import org.unidal.lookup.annotation.Named;

@Named(type=ModuleInitializer.class)
public class DefaultModuleInitializer
implements ModuleInitializer {
    @Inject
    private ModuleManager m_manager;
    @InjectAttribute
    private boolean m_verbose;
    private int m_index = 1;

    @Override
    public void execute(ModuleContext ctx) {
        Module[] modules = this.m_manager.getTopLevelModules();
        this.execute(ctx, modules);
    }

    @Override
    public void execute(ModuleContext ctx, Module ... modules) {
        LinkedHashSet<Module> all = new LinkedHashSet<Module>();
        this.info(ctx, "Initializing top level modules:");
        for (Module module : modules) {
            this.info(ctx, "   " + module.getClass().getName());
        }
        try {
            this.expandAll(ctx, modules, all);
            for (Module module : all) {
                if (module.isInitialized()) continue;
                this.executeModule(ctx, module, this.m_index++);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error when initializing modules! Exception: " + e, e);
        }
    }

    private synchronized void executeModule(ModuleContext ctx, Module module, int index) throws Exception {
        long start = System.currentTimeMillis();
        module.setInitialized(true);
        this.info(ctx, index + " ------ " + module.getClass().getName());
        module.initialize(ctx);
        long end = System.currentTimeMillis();
        this.info(ctx, index + " ------ " + module.getClass().getName() + " DONE in " + (end - start) + " ms.");
    }

    private void expandAll(ModuleContext ctx, Module[] modules, Set<Module> all) throws Exception {
        if (modules != null) {
            for (Module module : modules) {
                if (module == null || all.contains(module)) continue;
                if (module instanceof AbstractModule) {
                    ((AbstractModule)module).setup(ctx);
                }
                this.expandAll(ctx, module.getDependencies(ctx), all);
                all.add(module);
            }
        }
    }

    private void info(ModuleContext ctx, String message) {
        if (this.m_verbose) {
            ctx.info(message);
        }
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }
}

