/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup;

import org.junit.After;
import org.junit.Before;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.ContainerLoader;
import org.unidal.lookup.PlexusContainer;
import org.unidal.lookup.container.model.entity.Any;
import org.unidal.lookup.container.model.entity.ComponentModel;
import org.unidal.lookup.container.model.entity.ConfigurationModel;
import org.unidal.lookup.container.model.entity.RequirementModel;

public abstract class ComponentTestCase
extends ContainerHolder {
    private PlexusContainer m_container;

    protected <T> ComponentDefinition<T> defineComponent(Class<T> role) throws Exception {
        return this.defineComponent(role, null, role);
    }

    protected <T> ComponentDefinition<T> defineComponent(Class<T> role, Class<? extends T> implementation) throws Exception {
        return this.defineComponent(role, null, implementation);
    }

    protected <T> ComponentDefinition<T> defineComponent(Class<T> role, String roleHint, Class<? extends T> implementation) throws Exception {
        ComponentModel model = new ComponentModel();
        model.setImplementation(implementation.getName());
        model.setRole(role.getName());
        if (roleHint != null) {
            model.setRoleHint(roleHint);
        }
        this.getContainer().addComponentModel(model);
        return new ComponentDefinition(model);
    }

    @Override
    protected PlexusContainer getContainer() {
        return this.m_container;
    }

    @Before
    public void setUp() throws Exception {
        String configuration = this.getClass().getName().replace('.', '/') + ".xml";
        ContainerLoader.destroy();
        this.m_container = ContainerLoader.getDefaultContainer(configuration);
        System.setProperty("devMode", "true");
    }

    @After
    public void tearDown() throws Exception {
        ContainerLoader.destroy();
        this.m_container = null;
    }

    protected static final class ComponentDefinition<T> {
        private ComponentModel m_model;

        public ComponentDefinition(ComponentModel descriptor) {
            this.m_model = descriptor;
        }

        public ComponentDefinition<T> config(String name, String value) {
            Any element = new Any().setName(name).setValue(value);
            ConfigurationModel config = this.m_model.getConfiguration();
            if (config == null) {
                config = new ConfigurationModel();
                this.m_model.setConfiguration(config);
            }
            config.getDynamicElements().add(element);
            return this;
        }

        public ComponentDefinition<T> is(String instantiationStrategy) {
            this.m_model.setInstantiationStrategy(instantiationStrategy);
            return this;
        }

        public ComponentDefinition<T> req(Class<?> role) {
            return this.req(role, null);
        }

        public ComponentDefinition<T> req(Class<?> role, String roleHint) {
            RequirementModel requirement = new RequirementModel();
            requirement.setRole(role.getName());
            if (roleHint != null) {
                requirement.setRoleHint(roleHint);
            }
            this.m_model.addRequirement(requirement);
            return this;
        }
    }
}

