/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.configuration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.helper.Files;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.InjectAttribute;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.configuration.Component;
import org.unidal.lookup.configuration.Configuration;
import org.unidal.lookup.configuration.Configurators;
import org.unidal.tuple.Pair;

public abstract class AbstractResourceConfigurator {
    protected static final String PER_LOOKUP = "per-lookup";
    protected static final String ENUM = "enum";

    protected static <T> Component A(Class<T> clazz) {
        return AbstractResourceConfigurator.A(clazz, null);
    }

    protected static <T> Component A(Class<T> clazz, String enumField) {
        Named named = clazz.getAnnotation(Named.class);
        if (named == null) {
            throw new IllegalStateException(String.format("Class(%s) is not annotated by %s.", clazz.getName(), Named.class.getName()));
        }
        Class<Object> role = named.type();
        String roleHint = named.value();
        if (role == Named.Default.class) {
            role = clazz;
        } else if (!role.isAssignableFrom(clazz)) {
            throw new IllegalStateException(String.format("Class(%s) is not assignable from class(%s).", role.getName(), clazz, clazz.getName(), role.getName()));
        }
        if (enumField != null) {
            roleHint = enumField;
        } else if (roleHint.length() == 0) {
            roleHint = null;
        }
        Component component = new Component(role, roleHint, clazz);
        if (enumField != null) {
            if (clazz.isEnum()) {
                component.is(ENUM);
            }
        } else if (named.instantiationStrategy().length() > 0) {
            component.is(named.instantiationStrategy());
        }
        LinkedHashMap requires = new LinkedHashMap();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        AbstractResourceConfigurator.collectFields(clazz, requires, attributes);
        for (Map.Entry e : requires.entrySet()) {
            List list = (List)e.getValue();
            for (Pair item : list) {
                Object key = item.getKey();
                if (key instanceof String[]) {
                    String[] roleHints = (String[])key;
                    if (roleHints.length == 1) {
                        if (list.size() == 1) {
                            component.req((Class)e.getKey(), roleHints[0]);
                            continue;
                        }
                        component.req((Class)e.getKey(), roleHints[0], (String)item.getValue());
                        continue;
                    }
                    component.req((Class)e.getKey(), roleHints, (String)item.getValue());
                    continue;
                }
                if (list.size() == 1) {
                    component.req((Class)e.getKey(), (String)key);
                    continue;
                }
                component.req((Class)e.getKey(), (String)key, (String)item.getValue());
            }
        }
        for (Map.Entry attribute : attributes.entrySet()) {
            component.config(new Configuration((String)attribute.getKey()).value((String)attribute.getValue()));
        }
        return component;
    }

    protected static <T> Component C(Class<T> role) {
        return new Component(role);
    }

    protected static <T> Component C(Class<T> role, Class<? extends T> implementationClass) {
        return new Component(role, implementationClass);
    }

    protected static <T> Component C(Class<T> role, Object roleHint, Class<? extends T> implementationClass) {
        return new Component(role, roleHint, implementationClass);
    }

    private static void collectField(Class<?> clazz, Field field, Map<Class<?>, List<Pair<Object, String>>> requires, Map<String, String> attributes) {
        String value;
        Inject inject = field.getAnnotation(Inject.class);
        InjectAttribute injectAttribute = field.getAnnotation(InjectAttribute.class);
        if (inject != null && injectAttribute != null) {
            throw new IllegalStateException(String.format("Field(%s) can't be annotated by both %s and %s.", field.getName(), Inject.class.getName(), InjectAttribute.class.getName()));
        }
        if (inject != null) {
            Class<?> role = inject.type();
            String[] roleHints = inject.value();
            Class<?> type = field.getType();
            if (role != Inject.Default.class) {
                if (roleHints.length <= 1 && !role.isAssignableFrom(type)) {
                    throw new IllegalStateException(String.format("Field(%s) of %s can only be injected by subclass of %s instead of %s.", field.getName(), clazz, role.getName(), type.getName()));
                }
            } else {
                role = roleHints.length <= 1 ? field.getType() : AbstractResourceConfigurator.getElementType(field.getGenericType(), field);
            }
            if (roleHints.length <= 1) {
                List<Pair<Object, String>> require = requires.get(role);
                if (require == null) {
                    require = new ArrayList<Pair<Object, String>>(3);
                    requires.put(role, require);
                }
                if (roleHints.length == 0) {
                    require.add(new Pair<String, String>("default", field.getName()));
                } else if (roleHints.length == 1) {
                    require.add(new Pair<String, String>(roleHints[0], field.getName()));
                }
            } else {
                List<Pair<Object, String>> require = requires.get(role);
                if (require == null) {
                    require = new ArrayList<Pair<Object, String>>(3);
                    requires.put(role, require);
                }
                require.add(new Pair<String[], String>(roleHints, field.getName()));
            }
        }
        if (injectAttribute != null && !(value = injectAttribute.value()).equals("<DEFAULT>")) {
            String name = field.getName();
            if (name.startsWith("m_")) {
                name = name.substring(2);
            }
            attributes.put(name, value);
        }
    }

    private static void collectFields(Class<?> clazz, Map<Class<?>, List<Pair<Object, String>>> requires, Map<String, String> attributes) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            AbstractResourceConfigurator.collectField(clazz, field, requires, attributes);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            AbstractResourceConfigurator.collectFields(superClass, requires, attributes);
        }
    }

    protected static Configuration E(String name) {
        return new Configuration(name);
    }

    protected static void generatePlexusComponentsXmlFile(AbstractResourceConfigurator rc) {
        File file = rc.getConfigurationFile();
        try {
            rc.saveToFile(file);
            System.out.println(String.format("File %s generated. File length is %s.", file, file.length()));
        }
        catch (IOException e) {
            System.err.println(String.format("Error when generating %s file.", file));
            e.printStackTrace();
        }
    }

    private static Class<?> getElementType(Type type, Field field) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        throw new IllegalStateException(String.format("Unsupported type(%s) of field(%s) of %s, use List instead!", type, field.getName(), field.getDeclaringClass()));
    }

    public abstract List<Component> defineComponents();

    protected File getBaseDir() {
        URL url = this.getClass().getResource(this.getClass().getSimpleName() + ".class");
        String path = url.getPath();
        int pos = path.indexOf("/target/classes");
        if (pos < 0) {
            pos = path.indexOf("/target/test-classes");
        }
        if (pos > 0) {
            return new File(path.substring(0, pos));
        }
        return new File(".");
    }

    protected File getConfigurationFile() {
        File file;
        File baseDir = this.getBaseDir();
        Class<?> testClass = this.getTestClass();
        if (testClass != null) {
            file = new File(baseDir, String.format("src/test/resources/%s.xml", testClass.getName().replace('.', '/')));
        } else if (this.isMavenPlugin()) {
            file = new File(baseDir, "src/main/resources/META-INF/plexus/components.xml");
        } else {
            String projectName = baseDir.getName();
            file = new File(baseDir, String.format("src/main/resources/META-INF/plexus/components-%s.xml", projectName));
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    protected Class<?> getTestClass() {
        return null;
    }

    protected boolean isEnv(String name) {
        String env = System.getProperty("env");
        if (env != null && env.equals(name)) {
            return false;
        }
        return false;
    }

    protected boolean isMavenPlugin() {
        return false;
    }

    protected String property(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    protected void saveToFile(File file) throws IOException {
        File oldFile;
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String content = Configurators.forPlexus().generateXmlConfiguration(this.defineComponents());
        if (!this.isMavenPlugin() && this.getTestClass() == null && (oldFile = new File(parent, "components.xml")).exists()) {
            oldFile.delete();
        }
        Files.forIO().writeTo(file, content);
    }
}

