/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.container.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.unidal.lookup.ComponentLookupException;
import org.unidal.lookup.PlexusContainer;
import org.unidal.lookup.container.ComponentKey;
import org.unidal.lookup.container.ComponentManager;
import org.unidal.lookup.container.lifecycle.ComponentHandlers;
import org.unidal.lookup.container.lifecycle.LifecycleContext;
import org.unidal.lookup.container.lifecycle.LifecycleHandler;
import org.unidal.lookup.container.model.entity.ComponentModel;
import org.unidal.lookup.logging.Logger;

public class ComponentLifecycle {
    private List<LifecycleHandler> m_handlers = new ArrayList<LifecycleHandler>();
    private ComponentManager m_manager;

    public ComponentLifecycle(ComponentManager manager) {
        this.m_manager = manager;
        this.m_handlers.add(ComponentHandlers.REQUIREMENTS);
        this.m_handlers.add(ComponentHandlers.ENABLE_LOG);
        this.m_handlers.add(ComponentHandlers.ENABLE_ROLE_HINT);
        this.m_handlers.add(ComponentHandlers.CONTEXTUALIZABLE);
        this.m_handlers.add(ComponentHandlers.CONFIGURATION);
        this.m_handlers.add(ComponentHandlers.INITIALIZABLE);
    }

    public void addHandle(LifecycleHandler handler) {
        this.m_handlers.add(handler);
    }

    public void onStarted(ComponentModel model) {
        this.m_manager.log("Loaded component(%s:%s) with class(%s) ...", model.getRole(), model.getHint(), model.getImplementation());
    }

    public void onStarting(ComponentModel model) {
        this.m_manager.log("Loading component(%s:%s) with class(%s) ...", model.getRole(), model.getHint(), model.getImplementation());
    }

    public void start(Object component, ComponentModel model) throws ComponentLookupException {
        ComponentContext ctx = new ComponentContext(component).setComponentModel(model);
        for (LifecycleHandler handler : this.m_handlers) {
            handler.handleStart(ctx);
        }
    }

    public void stop(Object component) {
        ComponentContext ctx = new ComponentContext(component);
        for (LifecycleHandler handler : this.m_handlers) {
            handler.handleStop(ctx);
        }
    }

    private class ComponentContext
    implements LifecycleContext {
        private Object m_component;
        private ComponentModel m_model;

        public ComponentContext(Object component) {
            this.m_component = component;
        }

        @Override
        public Object getComponent() {
            return this.m_component;
        }

        @Override
        public ComponentModel getComponentModel() {
            return this.m_model;
        }

        @Override
        public PlexusContainer getContainer() {
            return ComponentLifecycle.this.m_manager.getContainer();
        }

        @Override
        public Logger getLogger(String role) {
            return ComponentLifecycle.this.m_manager.getLoggerManager().getLoggerForComponent(role);
        }

        @Override
        public Object lookup(String role, String roleHint) throws ComponentLookupException {
            return ComponentLifecycle.this.m_manager.lookup(new ComponentKey(role, roleHint));
        }

        public ComponentContext setComponentModel(ComponentModel model) {
            this.m_model = model;
            return this;
        }
    }
}

