/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.container.model.transform;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.unidal.lookup.container.model.IEntity;
import org.unidal.lookup.container.model.entity.Any;
import org.unidal.lookup.container.model.entity.ComponentModel;
import org.unidal.lookup.container.model.entity.ConfigurationModel;
import org.unidal.lookup.container.model.entity.PlexusModel;
import org.unidal.lookup.container.model.entity.RequirementModel;
import org.unidal.lookup.container.model.transform.DefaultLinker;
import org.unidal.lookup.container.model.transform.DefaultSaxMaker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static PlexusModel parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(PlexusModel.class, new InputSource(DefaultSaxParser.removeBOM(in)));
    }

    public static PlexusModel parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(PlexusModel.class, new InputSource(DefaultSaxParser.removeBOM(reader)));
    }

    public static PlexusModel parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(PlexusModel.class, new InputSource(new StringReader(DefaultSaxParser.removeBOM(xml))));
    }

    private static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(DefaultSaxParser.removeBOM(in)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(DefaultSaxParser.removeBOM(xml))));
    }

    private static <T> T removeBOM(T obj) throws IOException {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.charAt(0) == '\ufeff') {
                return (T)str.substring(1);
            }
            return obj;
        }
        if (obj instanceof InputStream) {
            BufferedInputStream in = new BufferedInputStream((InputStream)obj);
            in.mark(3);
            if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
                in.reset();
            }
            return (T)in;
        }
        if (obj instanceof Reader) {
            BufferedReader in = new BufferedReader((Reader)obj);
            in.mark(1);
            if (in.read() != 65279) {
                in.reset();
            }
            return (T)in;
        }
        return obj;
    }

    protected Any buildAny(String qName, Attributes attributes) {
        Any any = new Any();
        int length = attributes == null ? 0 : attributes.getLength();
        any.setName(qName);
        if (length > 0) {
            Map<String, String> dynamicAttributes = any.getAttributes();
            for (int i = 0; i < length; ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                dynamicAttributes.put(name, value);
            }
        }
        return any;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = this.m_tags.pop();
            if (currentObj instanceof ComponentModel) {
                ComponentModel component = (ComponentModel)currentObj;
                if ("role".equals(currentTag)) {
                    component.setRole(this.getText());
                } else if ("role-hint".equals(currentTag)) {
                    component.setRoleHint(this.getText());
                } else if ("implementation".equals(currentTag)) {
                    component.setImplementation(this.getText());
                } else if ("instantiation-strategy".equals(currentTag)) {
                    component.setInstantiationStrategy(this.getText());
                }
            } else if (currentObj instanceof RequirementModel) {
                RequirementModel requirement = (RequirementModel)currentObj;
                if ("role".equals(currentTag)) {
                    requirement.setRole(this.getText());
                } else if ("role-hint".equals(currentTag)) {
                    requirement.setRoleHint(this.getText());
                } else if ("field-name".equals(currentTag)) {
                    requirement.setFieldName(this.getText());
                }
            } else if (currentObj instanceof Any) {
                if (this.m_text.toString().length() != 0) {
                    ((Any)currentObj).setValue(this.m_text.toString());
                }
            } else if (currentObj instanceof ComponentModel) {
                if (this.m_text.toString().length() != 0) {
                    ((ComponentModel)currentObj).getDynamicElements().add(new Any().setValue(this.m_text.toString()));
                }
            } else if (currentObj instanceof ConfigurationModel) {
                if (this.m_text.toString().length() != 0) {
                    ((ConfigurationModel)currentObj).getDynamicElements().add(new Any().setValue(this.m_text.toString()));
                }
            } else if (currentObj instanceof RequirementModel && this.m_text.toString().length() != 0) {
                ((RequirementModel)currentObj).getDynamicElements().add(new Any().setValue(this.m_text.toString()));
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForComponent(ComponentModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("role".equals(qName) || "role-hint".equals(qName) || "implementation".equals(qName) || "instantiation-strategy".equals(qName) || "requirements".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("configuration".equals(qName)) {
            ConfigurationModel configuration = this.m_maker.buildConfiguration(attributes);
            this.m_linker.onConfiguration(parentObj, configuration);
            this.m_objs.push(configuration);
        } else if ("requirement".equals(qName)) {
            RequirementModel requirement = this.m_maker.buildRequirement(attributes);
            this.m_linker.onRequirement(parentObj, requirement);
            this.m_objs.push(requirement);
        } else {
            Any any;
            if (this.m_text.toString().length() != 0) {
                any = new Any().setValue(this.m_text.toString());
                parentObj.getDynamicElements().add(any);
            }
            any = this.buildAny(qName, attributes);
            parentObj.getDynamicElements().add(any);
            this.m_objs.push(any);
        }
        this.m_tags.push(qName);
    }

    private void parseForConfiguration(ConfigurationModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        Any any;
        if (this.m_text.toString().length() != 0) {
            any = new Any().setValue(this.m_text.toString());
            parentObj.getDynamicElements().add(any);
        }
        any = this.buildAny(qName, attributes);
        parentObj.getDynamicElements().add(any);
        this.m_objs.push(any);
        this.m_tags.push(qName);
    }

    private void parseForPlexus(PlexusModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("components".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("component".equals(qName)) {
            ComponentModel component = this.m_maker.buildComponent(attributes);
            this.m_linker.onComponent(parentObj, component);
            this.m_objs.push(component);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under plexus!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForRequirement(RequirementModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("role".equals(qName) || "role-hint".equals(qName) || "field-name".equals(qName)) {
            this.m_objs.push(parentObj);
        } else {
            Any any;
            if (this.m_text.toString().length() != 0) {
                any = new Any().setValue(this.m_text.toString());
                parentObj.getDynamicElements().add(any);
            }
            any = this.buildAny(qName, attributes);
            parentObj.getDynamicElements().add(any);
            this.m_objs.push(any);
        }
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("plexus".equals(qName)) {
            PlexusModel plexus;
            this.m_entity = plexus = this.m_maker.buildPlexus(attributes);
            this.m_objs.push(plexus);
            this.m_tags.push(qName);
        } else if ("component".equals(qName)) {
            ComponentModel component;
            this.m_entity = component = this.m_maker.buildComponent(attributes);
            this.m_objs.push(component);
            this.m_tags.push(qName);
        } else if ("configuration".equals(qName)) {
            ConfigurationModel configuration;
            this.m_entity = configuration = this.m_maker.buildConfiguration(attributes);
            this.m_objs.push(configuration);
            this.m_tags.push(qName);
        } else if ("requirement".equals(qName)) {
            RequirementModel requirement;
            this.m_entity = requirement = this.m_maker.buildRequirement(attributes);
            this.m_objs.push(requirement);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof Any) {
                Any any = this.buildAny(qName, attributes);
                ((Any)parent).addChild(any);
                this.m_objs.push(any);
                this.m_tags.push(qName);
            } else if (parent instanceof PlexusModel) {
                this.parseForPlexus((PlexusModel)parent, tag, qName, attributes);
            } else if (parent instanceof ComponentModel) {
                this.parseForComponent((ComponentModel)parent, tag, qName, attributes);
            } else if (parent instanceof ConfigurationModel) {
                this.parseForConfiguration((ConfigurationModel)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof RequirementModel)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForRequirement((RequirementModel)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

