package com.reyun.controller;

import com.reyun.model.Account;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.AppService;
import com.reyun.util.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;

/**
 * Created by nolan on 22/12/2016.
 * description:
 */
@Controller
@RequestMapping("app")
public class AppController {

    @Autowired
    private AppService appService;

    @RequestMapping(value = "findall", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAll(@CurrentAccount Account loginAccount) {
        System.out.print(loginAccount.getId());
        return ResultModel.OK(appService.listAppByAccount(loginAccount.getId()));
    }


    @RequestMapping(value = "find/{subAccountId}/AuthApp", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAuthApp(@CurrentAccount Account loginAccount, @PathVariable Long subAccountId){
        return ResultModel.OK(appService.listAuthAppByAccount(loginAccount, subAccountId));
    }
}
