package com.reyun.controller;

import com.reyun.model.Account;
import com.reyun.model.CustomMenuShare;
import com.reyun.model.CustomMenuTemplate;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.CustomMenuService;
import com.reyun.service.EventService;
import com.reyun.util.ResultModel;
import com.reyun.util.ResultStatus;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

/**
 * Created by sunhao on 17/4/24.
 * desc:看单controller
 */
@Controller
@RequestMapping("custommenu")
public class CustomMenuController {

    @Autowired
    private CustomMenuService customMenuService;
    @Autowired
    private EventService eventService;


    /**
     * 修改模板报表图表状态
     */
    @ResponseBody
    @RequestMapping(value = "industry", method = RequestMethod.GET)
    public ResultModel findIndustry() {
        return ResultModel.OK(customMenuService.findIndustry());
    }

    /**
     * 修改模板报表图表状态
     */
    @ResponseBody
    @RequestMapping(value = "updateType/{id}", method = RequestMethod.PUT)
    public ResultModel updateMenuType(@CurrentAccount Account account, @PathVariable Long id, @RequestParam String type) {
        return ResultModel.OK(customMenuService.updateMyMenuTemplateType(account.getId(), id, type));
    }

    /**
     * 修改模板顺序
     */
    @ResponseBody
    @RequestMapping(value = "updateIndex/{id}", method = RequestMethod.PUT)
    public ResultModel updateMenuIndex(@CurrentAccount Account account, @PathVariable Long id, @RequestParam int index) {
        customMenuService.updateMyMenuTemplateIndex(account.getId(), id, index);
        return ResultModel.OK();
    }

    /**
     * 修改看单顺序
     */
    @ResponseBody
    @RequestMapping(value = "updateIndex/{appId}/{menuId}", method = RequestMethod.PUT)
    public ResultModel updateMenuIndex(@CurrentAccount Account account, @PathVariable Long appId,
                                      @PathVariable Long menuId, @RequestParam int index) {
        customMenuService.updateMyMenuIndex(account.getId(), appId, menuId, index);
        return ResultModel.OK();
    }

    /**
     * 查询所有看单内的报表
     */
    @ResponseBody
    @RequestMapping(value = "report/{appId}/{originalReportId}", method = RequestMethod.GET)
    public ResultModel queryAllReport(@CurrentAccount Account account, @PathVariable Long appId, @PathVariable Long originalReportId,
                                      @RequestParam String menuType,@RequestParam String startDate,@RequestParam String endDate,
                                      @RequestParam String viewFlag) {

        if (null != originalReportId && !StringUtils.isEmpty(menuType) && !StringUtils.isEmpty(startDate) && !StringUtils.isEmpty(endDate)) {

            return ResultModel.OK(customMenuService.queryAllReport(account.getId(), appId, originalReportId, menuType, startDate, endDate, viewFlag));

        } else {
            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }
    }

    /**
     * 获取所有的看单菜单名称
     */
    @ResponseBody
    @RequestMapping(value = "findName/{appId}", method = RequestMethod.GET)
    public ResultModel getAllMyCustomMenuName(@CurrentAccount Account account, @PathVariable Long appId) {
        return ResultModel.OK(customMenuService.listMyMenuList(account.getId(), appId));
    }

    /**
     * 获取某个看单详情
     */
    @ResponseBody
    @RequestMapping(value = "findDetail/{menuId}", method = RequestMethod.GET)
    public ResultModel getMyCustomMenuDetail(@PathVariable Long menuId){
        return ResultModel.OK(customMenuService.getMyMenuDetail(menuId));
    }

    /**
     * 查询是否有看单和收藏
     */
    @ResponseBody
    @RequestMapping(value = "find/{appId}", method = RequestMethod.GET)
    public ResultModel findAll(@CurrentAccount Account account,@PathVariable Long appId){
        return ResultModel.OK(customMenuService.findAllMenuAndFavorite(account.getId(),appId));
    }

    /**
     * 查询行业看单列表
     */
    @ResponseBody
    @RequestMapping(value = "findShare/{appId}", method = RequestMethod.GET)
    public ResultModel findAllShare(@CurrentAccount Account account, @PathVariable Long appId) {

        return ResultModel.OK(customMenuService.listAllSharedMenuByCategory(account.getId(), appId));
    }

    /**
     * 查询我的看单
     */
    @ResponseBody
    @RequestMapping(value = "findMy/{appId}", method = RequestMethod.GET)
    public ResultModel findMyCustomMenu(@CurrentAccount Account account, @PathVariable Long appId) {
        return ResultModel.OK(customMenuService.listMyCustomMenu(account.getId(), appId));
    }

    /**
     * 查询我的收藏
     */
    @ResponseBody
    @RequestMapping(value = "findFavo/{appId}", method = RequestMethod.GET)
    public ResultModel finaMyFavorite(@CurrentAccount Account account, @PathVariable Long appId) {
        return ResultModel.OK(customMenuService.listMyFavorite(account.getId(), appId));
    }

    /**
     * 自己创建看单
     */
    @ResponseBody
    @RequestMapping(value = "saveMenu/{appId}", method = RequestMethod.POST)
    public ResultModel saveCustomMenu(@CurrentAccount Account account, @PathVariable Long appId, @RequestParam String name) {

        name = name.trim();

        //参数校验
        if(null == appId || StringUtils.isEmpty(name)){
            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }

        //数量校验
        if(!customMenuService.validMyMenuNumber(account.getId(), appId)){
            return ResultModel.ERROR(ResultStatus.NUMBER_LIMIT);
        }

        //名字校验
        if(!customMenuService.validMyMenuName(appId, name)){
            return ResultModel.ERROR(ResultStatus.NAME_EXIST);
        }

        return ResultModel.OK(customMenuService.createMyMenu(account.getId(), appId, name));

    }

    /**
     * 添加模板
     * customMenuTemplate参数传menuType和id
     */
    @ResponseBody
    @RequestMapping(value = "addTemp/{appId}/{menuId}", method = RequestMethod.POST)
    public ResultModel saveMenuTemplate(@CurrentAccount Account account, @PathVariable Long appId,
                                        @PathVariable Long menuId, @RequestBody CustomMenuTemplate customMenuTemplate) {
        //参数校验
        if(null == appId || null == customMenuTemplate || StringUtils.isEmpty(customMenuTemplate.getMenuType())
                || null == customMenuTemplate.getOriginalReportId()){
            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }

        //校验数量和重复
        ResultModel resultModel = customMenuService.validMenuTemplate(account.getId(), menuId, customMenuTemplate.getOriginalReportId(),customMenuTemplate.getMenuType());

        if (ResultStatus.SUCCESS.getCode() != resultModel.getCode()) {
            return resultModel;
        }

        //调用加入
        CustomMenuTemplate template = customMenuService.addCustomMenuTemplate(account, appId, menuId, customMenuTemplate);

        if (null == template) {
            return ResultModel.ERROR(ResultStatus.FAILED);
        }

        //加入成功
        return ResultModel.OK(template);
    }

    /**
     * 添加行业看单到我的看单
     */
    @ResponseBody
    @RequestMapping(value = "addMenu/{appId}", method = RequestMethod.POST)
    public ResultModel addShareMenu(@CurrentAccount Account account, @PathVariable Long appId, @RequestBody CustomMenuShare customMenuShare) {
        //参数验证
        if(null == appId || CollectionUtils.isEmpty(customMenuShare.getTemplates())){
            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }
        //数量验证
        if(!customMenuService.validMyMenuNumber(account.getId(), appId)){
            return ResultModel.ERROR(ResultStatus.NUMBER_LIMIT);
        }
        //是否已经加入验证
        if(customMenuService.validIsExists(appId,customMenuShare.getId())){
            return ResultModel.ERROR(ResultStatus.RECORD_EXIST);
        }

        //加入热云看单
        return ResultModel.OK(customMenuService.addToMyMenu(account, appId, customMenuShare));


    }

    /**
     * 添加热云看单到我的看单
     */
    @ResponseBody
    @RequestMapping(value = "addReyun/{appId}", method = RequestMethod.POST)
    public ResultModel addReyunMenu(@CurrentAccount Account account, @PathVariable Long appId) {

        //校验是否加过
        if(customMenuService.findAllMenuAndFavorite(account.getId(), appId)){
            return ResultModel.ERROR(ResultStatus.RECORD_EXIST);
        }

        //无事件处理
        if (CollectionUtils.isEmpty(eventService.findAllEventWithAttr(appId))) {
            return ResultModel.ERROR(ResultStatus.EVENT_NULL);
        }

        return ResultModel.OK(customMenuService.addReyunToMyMenu(account, appId));
    }

    /**
     * 添加分享看单到收藏夹
     */
    @ResponseBody
    @RequestMapping(value = "addFavorite/{appId}/{menuId}", method = RequestMethod.POST)
    public ResultModel addFavorite(@CurrentAccount Account account, @PathVariable Long appId, @PathVariable Long menuId) {

        return ResultModel.OK(customMenuService.addToFavorite(account.getId(), appId, menuId));
    }


    /**
     * 修改看单名字
     */
    @ResponseBody
    @RequestMapping(value = "updateName/{appId}/{menuId}", method = RequestMethod.PUT)
    public ResultModel updateMenuName(@CurrentAccount Account account, @PathVariable Long appId,
                                      @PathVariable Long menuId, @RequestParam String name) {
        //名字校验
        if (!customMenuService.validMyMenuName(appId, name)) {
            return ResultModel.ERROR(ResultStatus.NAME_EXIST);
        }

        return ResultModel.OK(customMenuService.updateMyMenuName(account.getId(), menuId, name));
    }

    /**
     * 删除我的看单
     */
    @ResponseBody
    @RequestMapping(value = "delMenu/{appId}/{menuId}", method = RequestMethod.DELETE)
    public ResultModel delCustomMenu(@CurrentAccount Account account, @PathVariable Long appId, @PathVariable Long menuId) {
        return ResultModel.OK(customMenuService.deleteMyMenu(account.getId(), appId, menuId));
    }

    /**
     * 删除看单模板
     */
    @ResponseBody
    @RequestMapping(value = "delTemp/{templateId}", method = RequestMethod.DELETE)
    public ResultModel delCustomMenuTemplate(@CurrentAccount Account account, @PathVariable Long templateId) {
        return ResultModel.OK(customMenuService.deleteMyMenuTemplate(account.getId(), templateId));
    }

    /**
     * 删除收藏夹
     */
    @ResponseBody
    @RequestMapping(value = "delFavorite/{appId}/{menuId}", method = RequestMethod.DELETE)
    public ResultModel delFavorite(@CurrentAccount Account account, @PathVariable Long appId, @PathVariable Long menuId) {
        return ResultModel.OK(customMenuService.deleteFavorite(account.getId(), appId, menuId));
    }

    /**
     * 取消分享
     */
    @ResponseBody
    @RequestMapping(value = "cancelShare/{appId}/{menuId}", method = RequestMethod.DELETE)
    public ResultModel cancelShareMyMenu(@CurrentAccount Account account, @PathVariable Long appId, @PathVariable Long menuId) {

        return ResultModel.OK(customMenuService.cancelShareMyMenu(account.getId(), appId, menuId));
    }

    /**
     * 删除漏斗、留存、事件分析删除是验证是否有看单引用
     */
    @ResponseBody
    @RequestMapping(value = "delete/valid/{id}", method = RequestMethod.GET)
    public ResultModel deleteFunnel(@CurrentAccount Account account, @PathVariable Long id, @RequestParam String type) {
        return ResultModel.OK(customMenuService.listByReportId(id, type));
    }
}
