package com.reyun.controller;

import com.reyun.model.Account;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.ComplicateEventsService;
import com.reyun.service.EventStatsService;
import com.reyun.util.ResultModel;
import com.reyun.util.ResultStatus;
import com.reyun.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by sunhao on 17/4/10.
 *
 */
@Service
@RequestMapping("eventstats")
public class EventStatsController {


    @Autowired
    private ComplicateEventsService complicateEventsService;


    @RequestMapping(value = "complicated/query/{appId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel queryComplicatedEvent(HttpServletRequest httpServletRequest, @CurrentAccount Account account,
                                       @PathVariable Long appId) {

        String startDate = httpServletRequest.getParameter("startdate");
        String endDate = httpServletRequest.getParameter("enddate");
         String eventCondition = httpServletRequest.getParameter("eventCondition");
        String viewFlag = httpServletRequest.getParameter("viewflag");

        if (!StringUtil.isEmpty(eventCondition) && !StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {

            return ResultModel.OK(complicateEventsService.queryComplicatedEvent(appId, account.getId(), startDate, endDate,
                    eventCondition, viewFlag));
        } else {

            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }

    }

    @RequestMapping(value = "complicated/query/total/{appId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel queryDistinctTotal(HttpServletRequest httpServletRequest, @CurrentAccount Account account,
                                             @PathVariable Long appId) {

        String startDate = httpServletRequest.getParameter("startdate");
        String endDate = httpServletRequest.getParameter("enddate");
        String eventCondition = httpServletRequest.getParameter("eventCondition");
        String viewFlag = httpServletRequest.getParameter("viewflag");

        if (!StringUtil.isEmpty(eventCondition) && !StringUtil.isEmpty(startDate) && !StringUtil.isEmpty(endDate)) {

            return ResultModel.OK(complicateEventsService.queryDistinctTotalData(appId, account.getId(), startDate, endDate,
                    eventCondition, viewFlag));
        } else {

            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }

    }
}
