package com.reyun.controller;

import com.reyun.model.App;
import com.reyun.model.ComplicatedParam;
import com.reyun.model.EventAttr4Web;
import com.reyun.service.AppService;
import com.reyun.service.EventService;
import com.reyun.service.ExpressionService;
import com.reyun.util.ResultModel;
import com.reyun.util.ResultStatus;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("expression")
public class ExpressionController {

    @Autowired
    private ExpressionService expressionService;
    @Autowired
    private EventService eventService;
    @Autowired
    private AppService appService;

    @ResponseBody
    @RequestMapping(value = "transform", method = RequestMethod.POST)
    public ResultModel transform(@RequestBody String param) {
//        System.out.println(param);
        JSONObject jsonObject = JSONObject.fromObject(param);
        String expression = jsonObject.get("expression").toString();
        String appKey = jsonObject.get("appkey").toString();
        long appId = Long.parseLong(appKey);

        App byId = this.appService.findById(appId);
        appKey = byId.getAppkey();

//        boolean isValidate = expressionService.validateOriginalExpression(expression, appKey);
        String mid = expressionService.originalExpressionToMidExp(expression, appKey);
        if (mid == null) {
            return ResultModel.ERROR(ResultStatus.EXP_INVALID);
        } else {
            return ResultModel.OK(mid);
        }
    }

    @ResponseBody
    @RequestMapping(value = "properties/{event}/{appId}", method = RequestMethod.GET)
    public ResultModel properties(@PathVariable String event, @PathVariable Long appId) {

        List<EventAttr4Web> eventAttributeMetas = eventService.listAllEventAttribute(event, appId);
        return ResultModel.OK(eventAttributeMetas);
    }


    @ResponseBody
    @RequestMapping(value = "viewList", method = RequestMethod.GET)
    public ResultModel operations() {

        List<ComplicatedParam> allEventViewAttr = eventService.findAllComplicatedPatram();
        List<ComplicatedParam> eventViewList = new ArrayList<>(allEventViewAttr.size());
        List<ComplicatedParam> attrViewList = new ArrayList<>(allEventViewAttr.size());

        for (ComplicatedParam complicatedParam : allEventViewAttr) {
            switch (complicatedParam.getAttrLevel()) {
                case 1:
                    eventViewList.add(complicatedParam);
                    continue;
                case 2:
                    attrViewList.add(complicatedParam);
                    continue;
            }
        }
        Map<String, Object> stringObjectMap = new HashMap<>(2);
        stringObjectMap.put("eventViewList", eventViewList);
        stringObjectMap.put("attrViewList", attrViewList);

        return ResultModel.OK(stringObjectMap);
    }
}
